#include "treetest.h"

#define DEBUG3	1 // Debug fr Test in den Methoden

#if DEBUG3 != 0 // Debug fr Test in den Methoden
	#define D3(x) RLOG("[" << GetSysTime() << "." << int(GetTickCount() % 10000u) << "] " << x)
#else
	#define D3(x)
#endif


TreeTest::TreeTest()
{
    String title = "TEST";
   	Title(title);

    SetRect(0,0,200,300);
    Zoomable(false).CenterScreen();

    AddFrame(_mytoolbar);
    _mytoolbar.Set(THISBACK(LocalBar));
    

	_myTree.NoRoot();
    _myTree.MouseMoveCursor();
    _myTree.PopUpEx();
	_myTree.WhenDropInsert = THISBACK(DropInsert);
	_myTree.WhenDrag = THISBACK(Drag);

	_counter = 0;
	
	Add(_myTree.SizePos());

    D3("TreeTest::TreeTest() created");
}


void TreeTest::DropInsert(int parent, int ii, PasteClip& d)
{
	if (1 < parent)
	return;
	
	// ursprngliche Position des Elementes speichern: _posElement = 0
	PosElement[_posElement] = ii;
	// umstellen auf Endposition
	_posElement = 1;

	_myTree.AdjustAction(parent, d);
	if(AcceptInternal<TreeCtrl>(d, "mytreedrag")) {
		_myTree.SetFocus();
		
		
		D3("DeviceTree::DropInsert(int parent, int ii, PasteClip& d) from " <<
			PosElement[0] <<" to " << PosElement[1]<<"of" <<_myTree.GetLineCount());

		_posElement = 0;

		Refresh();
		return;
	}
	if(AcceptText(d)) {
		_myTree.SetCursor(_myTree.Insert(parent, ii, Image(), GetString(d)));
		_myTree.SetFocus();
		return;
	}
}

void TreeTest::Drag()
{
	
	if(_myTree.DoDragAndDrop(InternalClip(_myTree, "mytreedrag"),
	                       _myTree.GetDragSample()) == DND_MOVE)
	     RefreshLayout();
}

/*--------------------------------------------------------------------------------------------*/ 
void TreeTest::Paint(Draw& draw)
{
  	if (ismodifiedDevice())
   	{
   	    checkDevices();
   	    setmodifiedDevice();
   	}
}

void TreeTest::checkDevices()
{
    int count=0;
    count = _deviceList.GetCount();
	if (count)
	{
	    _myTree.Clear();
	    for (int i = 0; i < count; i++)
	    {
	        int id;
	        id = _myTree.Add(0);
	        _myTree.Set(id,_deviceList[i]->getName());
		}
    }
}

void TreeTest::LocalBar(Bar &bar)
{
 	bar.Add("new",CtrlImg::MkDir(),THISBACK(createDummyDevice))
 		.Key(K_CTRL_N)
 		.Help("create dummy device");   
}


void TreeTest::createDummyDevice()
{
    D3("DeviceTree::createDummyDevice()");
    createDevice(0);
    Refresh();
}

bool TreeTest::createDevice(int handle)
{
    Devices * newDevice = new Devices(handle, "0.0.0.0");
    newDevice->setName(Sprintf("nummer: %d",_counter));
    _deviceList.Add();
    _deviceList[_deviceList.GetCount()-1] = newDevice;

    setmodifiedDevice(true);
    _counter++;

}

bool TreeTest::setmodifiedDevice(bool status)
{
    return _ismodifiedDevice = status;
}

bool TreeTest::ismodifiedDevice()
{
    return _ismodifiedDevice;
}

GUI_APP_MAIN
{
	TreeTest().Run();
}


