#ifndef _MyTreeCtrl_MyTreeCtrl_h
#define _MyTreeCtrl_MyTreeCtrl_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#include "device.h"

#define DEBUG2	1 // Debug fr Test in den Methoden

#if DEBUG2 != 0 // Debug fr Test in den Methoden
	#define D2(x) RLOG("[" << GetSysTime() << "." << int(GetTickCount() % 10000u) << "] " << x)
#else
	#define D2(x)
#endif

#define IMAGEFILE <MyTreeCtrl/MyTreeCtrl.iml>
#include <Draw/iml_header.h>

class TreeGroups:	Moveable<TreeGroups>
{
public:
	TreeGroups(){_name = "";_childs = 0;_isopen = false;}
	TreeGroups(const TreeGroups &tgroup, int)
	{
		_name = tgroup._name;
		D2("TreeGroups(const TreeGroups &tgroup, int id)" << _name << ", " << _childs);
	}
	
	void 	setName(String name)		{_name 		= name;}
	void	setChildCount(int childs)	{_childs  	= childs;}
	void	setOpen(bool status=true)	{_isopen	= status;}
	String 	getName()					{return _name;}
	int		getChildCount()				{return _childs;}
	bool	isOpen()					{return _isopen;}
	
private:
	String 	_name;
	int		_childs;
	bool	_isopen;
};

struct DeviceMap
{
	int _treepos;
	int _devicenum;
	
	DeviceMap(int tree=0, int device = 0):
		_treepos(tree), _devicenum(device) {}
	
	int getDevice()
	{
		return _devicenum;
	}
};

class MyTreeCtrl : public TopWindow {
public:
	typedef MyTreeCtrl CLASSNAME;
	MyTreeCtrl();
	
	void 		DropInsert(int parent, int ii, PasteClip& d);
	void 		Drag();    
    
    void		createGroupsinTree();
    void 		createDevicesinTree();
    void 		Paint(Draw& draw);
	
private:
	void		createMenuBar(Bar &bar);
	void		treeSubBar(Bar &bar);
    void 		createDummyDevice();
    void		createGroup();
    bool		deleteGroup(const int id);
    bool		updateDevicesParents(const int id);
    bool		deleteDevice(const int id);
    void		printDevices();
    void		deleteTreeElement();
    void 		dummyCallback(){D2("dummyCallback");}
    
    
	int			getElementId(const TreeCtrl& src,int num = 0) {return src.GetSel()[num];}
	
	bool		createDevice(int handle);
	bool		moveDevice(int oldpos, int newpos);
	bool		setmodifiedDevice(bool status = false) 	{_ismodifiedDevice = status;}
	bool		ismodifiedDevice()						{return _ismodifiedDevice;}
	
private:

	TreeCtrl	_myTree;
	ToolBar		_mytoolbar;

	int			_posElement;
	int			_counter;
	int			_gcounter;
	bool		_ismodifiedDevice;
	int			_groups;
	bool		_isMovedElement;
	
	Vector<Devices *>	_deviceList;
	Array<int>			_deviceMap; 	/**<Index identisch mit Index _deviceList, value entspricht TreeNummber */
	Vector<TreeGroups>	_treeGroups;
};

#endif

