#include "MyTreeCtrl.h"

#define DEBUG3	1 // Debug fr Test in den Methoden

#if DEBUG3 != 0 // Debug fr Test in den Methoden
	#define D3(x) RLOG("[" << GetSysTime() << "." << int(GetTickCount() % 10000u) << "] \t" << x)
#else
	#define D3(x)
#endif


#define IMAGEFILE <MyTreeCtrl/MyTreeCtrl.iml>
#include <Draw/iml_source.h>

MyTreeCtrl::MyTreeCtrl()
{
    String title = "TEST";
   	Title(title);

    SetRect(0,0,200,300);
    Zoomable(false).CenterScreen();

    AddFrame(_mytoolbar);
    _mytoolbar.Set(THISBACK(createMenuBar));
    

	_myTree.NoRoot();
    _myTree.MouseMoveCursor();
    _myTree.PopUpEx();
	_myTree.WhenDropInsert = THISBACK(DropInsert);
	_myTree.WhenDrag = THISBACK(Drag);
	_myTree.WhenBar = THISBACK(treeSubBar);
	_myTree.MultiSelect(false);

	_counter = 0;
	_gcounter = 0;
	
	Add(_myTree.SizePos());

    D3("MyTreeCtrl::MyTreeCtrl() created");
    
}

void MyTreeCtrl::createMenuBar(Bar &bar)
{
    /**
 	bar.Add("new Device",CtrlImg::open(),THISBACK(dummyCallback))
 		.Key(K_CTRL_O)
 		.Help("open config");   
	
 	bar.Add("new Device",CtrlImg::save(),THISBACK(dummyCallback))
 		.Key(K_CTRL_S)
 		.Help("save config");   
	*/
	/**
 	bar.Add("new Device",CtrlImg::save_as(),THISBACK(dummyCallback))
 		.Key(K_CTRL_U)
 		.Help("save as new file");   
	bar.Gap(12);
 	*/	
	
 	bar.Add("new Device",CtrlImg::new_doc(),THISBACK(createDummyDevice))
 		.Key(K_CTRL_N)
 		.Help("create dummy device");   
	
	bar.Add("new Group",CtrlImg::menu_window(),THISBACK(createGroup))
		.Key(K_CTRL_G)
		.Help("create new group");
	
	/**	
	bar.Gap(12);
	
	bar.Add("print",CtrlImg::print(),THISBACK(printDevices))
		.Key(K_CTRL_P)
		.Help("Print Devices to  Logfile");
	*/		
}

void MyTreeCtrl::treeSubBar(Bar &bar)
{
	bar.Add("Delete Element",THISBACK(deleteTreeElement));
}

void MyTreeCtrl::DropInsert(int parent, int ii, PasteClip& d)
{
	int currentId = getElementId(GetInternal<TreeCtrl>(d));
	//D3("MyTreeCtrl::DropInsert() : parent(" << parent << ") ii(" << ii << ") " << id);
	
	/* When remove '_isMovedElement == false' then the whole DND is done twice!?! */
	if(_groups >= parent  && _groups < currentId && 0 != parent && _isMovedElement ==false)
	{
		//_myTree.AdjustAction(parent, d);
		if(AcceptInternal<TreeCtrl>(d, "mytreedrag")) {
			//_myTree.SetFocus();
			
			/**
			D3("MyTreeCtrl::DropInsert() : parent(" << parent << ") ii(" << ii << ") "
				<<" id(" << currentId <<")"
				);*/
			int newpos = 0, oldpos = 0;
			/* Element ber die Map im Vektor finden und modifizieren*/
			for (int i = 0; i < _deviceMap.GetCount(); i++)
			{
				if (currentId == _deviceMap[i])
				{
					//D3("MyTreeCtrl::DropInsert() : Element gefunden!");
					_deviceList[i]->setParent(parent);
					oldpos = i;
					//break;
				}
				//D3("MyTreeCtrl::DropInsert() : Element suchen! index(" << i << ")");
			}
			/*	Neue Position des Elementes im Vector _deviceList berechnen*/
			for (int i = 0; i < parent-1; i++)
			{
				//D3("MyTreeCtrl::DropInsert() : Element Position! newpos(" << newpos << ") ii(" << ii <<")");
				newpos += _treeGroups[i].getChildCount();
			}
			/**	nachdem die Elemente der anderen Gruppen zusammengezhlt sind, muss noch die 
				Position im aktuellen Zweig hinzu addiert werden */
			if (0 < ii)
			{
				newpos += ii;
			}
			
			/* beim Verschieben nach unten (optisch gesehen) muss das alte Objekt abgezogen werden*/
			if (newpos > oldpos)
			{
				newpos -= 1;
			}
			
			D3("MyTreeCtrl::DropInsert() : ready"
			   << " old pos("<< oldpos << ")"
			   << " new pos("<< newpos << ")"
				);
			
			if(moveDevice(oldpos,newpos))
			{
				setmodifiedDevice(true);
				_isMovedElement= true;
			}

			//Refresh();
			return;
		}
		if(AcceptText(d)) {
			_myTree.SetCursor(_myTree.Insert(parent, ii, Image(), GetString(d)));
			_myTree.SetFocus();
			return;
		}
	}
}

void MyTreeCtrl::Drag()
{
	if(_myTree.DoDragAndDrop(InternalClip(_myTree, "mytreedrag"),
	                       _myTree.GetDragSample()) == DND_MOVE)
	{
	    D3("MyTreeCtrl::Drag(): IF(DND_MOVE)");
	    Refresh();
    }
	if(_myTree.DoDragAndDrop(InternalClip(_myTree, "mytreedrag"),
	                       _myTree.GetDragSample()) == DND_COPY)
    {
	    D3("MyTreeCtrl::Drag(): IF(DND_COPY)");
    	Refresh();
    }
}

/*--------------------------------------------------------------------------------------------*/ 
void MyTreeCtrl::Paint(Draw& draw)
{
  	if (ismodifiedDevice())
   	{
   		{ // Save information about groups in the tree (open/closed)
   			int newgroup = 0;
   			if (_myTree.GetChildCount(0) < _treeGroups.GetCount())
   			{
   				newgroup = 1;
   			}
   			
			for (int id = 0; id < _treeGroups.GetCount()-newgroup ; id++)
			{
				_treeGroups[id].setOpen(_myTree.IsOpen(id+1));
				/**
				D3("MyTreeCtrl::Paint() Groupstatus(" << id << ") :" << _treeGroups[id].isOpen()
					<< " Info: " <<_myTree.IsOpen(id+1));
				*/
			}
   		}
   		
		/*	remove old elements from tree, clear map and set status for dnd*/
   		_myTree.Clear();
   		_deviceMap.Clear();
   		_isMovedElement = false;
   		
   		/* 	create tree - elmenents */
   	    createGroupsinTree();
   	    createDevicesinTree();
   	    
		//D3("MyTreeCtrl::Paint ROOT     \tchilds ("<< _myTree.GetChildCount(0)-_groups <<")" );
		for (int id = 0; id < _treeGroups.GetCount(); id++)
		{
			/* 	count group members */
			_treeGroups[id].setChildCount(_myTree.GetChildCount(id+1));
			/*	set old status in tree (open/closed) */
			_myTree.Open(id+1,_treeGroups[id].isOpen());
			
			//D3("MyTreeCtrl::Paint Group (" << id << ") \tchilds ("<< _treeGroups[id].getChildCount() <<")" );
		}
   	    
   	    /* Set Status to false (default value) */
   	    setmodifiedDevice();
   	}
}

void MyTreeCtrl::createGroupsinTree()
{
	int count = 0;
	count = _treeGroups.GetCount();
	if (count)
	{
		//D3("MyTreeCtrl::createGroups()");
		for (int i =0; i < count; i++)
		{
			int id = _myTree.Add(0);
			_myTree.Set(id,_treeGroups[i].getName());
		}
	}
}

void MyTreeCtrl::createDevicesinTree()
{
    int count=0;
    count = _deviceList.GetCount();
	if (count)
	{
		//D3("MyTreeCtrl::createDevices()");
	    for (int i = 0; i < count; i++)
	    {
	        int id, parent;
	        parent = _deviceList[i]->getParent();
	        
	        if ( 0 > parent  || _groups < parent)
	        {
	            parent = 0;
	            /* set parent of element without available group back too root (0) */
	            _deviceList[i]->setParent(parent);
	        }
	        
	        id = _myTree.Add(parent);
	        _myTree.Set(id,_deviceList[i]->getName());
	        
	        /* Index des Array entspricht dem Index im Vector _deviceList*/
	        _deviceMap.Add(id);
		}
    }
}


void MyTreeCtrl::createDummyDevice()
{
    //D3("MyTreeCtrl::createDummyDevice()");
    createDevice(0);
    Refresh();
}

void MyTreeCtrl::createGroup()
{
	//D3("MyTreeCtrl::createGroup()");

	TreeGroups tmp;
	tmp.setName(Sprintf("Group %2d",_gcounter));
	_gcounter++;
	_treeGroups.Add(tmp);
	setmodifiedDevice(true);
	_groups = _treeGroups.GetCount();
	Refresh();
}

bool MyTreeCtrl::deleteGroup(const int id)
{
	if (id < _treeGroups.GetCount() && 0 <= id)
	{
		D3("MyTreeCtrl::deleteGroup (" << id<<")");
		_treeGroups.Remove(id);
		_groups = _treeGroups.GetCount();
		
		/*	der Zhler fr die Gruppen beginnt bei 1, der Index des Vectors bei 0*/
		updateDevicesParents(id+1);
		
		setmodifiedDevice(true);
		Refresh();
		return true;
	}
	else
	{
		D3("MyTreeCtrl::deleteGroup (" << id<<")");
		return false;
	}
}

bool MyTreeCtrl::updateDevicesParents(const int id)
{
    int pos = 0;
   	for (int i = pos; i < _deviceList.GetCount(); i++)
   	{
        pos = i;
        D3("MyTreeCtrl::updateDevicesParents (" << id<<")" << " index (" << i<<")");
   	    if( _deviceList[i]->getParent() == id)
   	    {
   	        _deviceList[i]->setParent(0);
   	        _deviceList.Add();
   	        _deviceList[_deviceList.GetCount()-1] = _deviceList[i];
   	        _deviceList.Remove(i);
   	        i--;
   	    }
   	}
    
    /*	und zum Abschluss noch die Gruppen neu setzen*/
    for (int i = 0; i < _deviceList.GetCount(); i++)
    {
		if( id < _deviceList[i]->getParent())
    	{
    	    _deviceList[i]->setParent(_deviceList[i]->getParent()-1);
    	}
    }
}

bool MyTreeCtrl::deleteDevice(const int id)
{
	if (id >= 0 && id < _deviceList.GetCount() )
	{
		D3("MyTreeCtrl::deleteDevice("<<id <<")");
		Devices * tmp = _deviceList[id];
		_deviceList[id] = NULL;
		_deviceList.Remove(id);
		delete(tmp);
		setmodifiedDevice(true);
		Refresh();
		return true;
	}
	else
	{
		return false;
	}
}

void MyTreeCtrl::printDevices()
{
	for (int i = 0; i < _deviceList.GetCount(); i++)
	{
		D3("MyTreeCtrl::printDevices() index(" << i << ") :" << _deviceList[i]->getName()
		   << "  \tparent("<< _deviceList[i]->getParent()<< ")"
			);
	}
}

void MyTreeCtrl::deleteTreeElement()
{
	int id = _myTree.GetCursor();
	//D3("MyTreeCtrl::deleteTreeElement()" << id << " ");
	String message = "";
	
	if (id <= _treeGroups.GetCount())
	{
		message << "Do you want to delete the Group: '" << (String)_myTree.GetValue(id) <<"'";
		if(PromptOKCancel(message))
		{
			D3("MyTreeCtrl::deleteTreeElement() delete("<< id << ") ");
			deleteGroup(id -1);
		}
		else
		{
			D3("MyTreeCtrl::deleteTreeElement() do not delete(" << id << ") ");
		}
	}
	else if (id > _treeGroups.GetCount())
	{
		for (int i = 0; i < _deviceMap.GetCount(); i++)
		{
			if (id == _deviceMap[i])
			{
				message << "Do you want to delete the Device: '" << (String)_myTree.GetValue(id) <<"'";
				if(PromptOKCancel(message))
				{
					D3("MyTreeCtrl::deleteTreeElement() delete("<< id << ") ");
					deleteDevice(i);
				}
				else
				{
					D3("MyTreeCtrl::deleteTreeElement() do not delete(" << id << ") ");
				}
			}
		}
	}
	
}

bool MyTreeCtrl::moveDevice(int oldpos, int newpos)
{
	if(0 <= oldpos && 0 <= newpos && _deviceList.GetCount() > oldpos && _deviceList.GetCount() > newpos)
	{
		//D3("MyTreeCtrl::moveDevice( ..) sort elements");
	    if (newpos < oldpos)
	    {
        	for (int i = newpos; i < oldpos; i++)
        	{
        		//D3("MyTreeCtrl::moveDevice() down to ("<<newpos<<")(" << i << ")(" << oldpos << ")");
        		_deviceList.Swap(i,oldpos);
        	}
	    }
	    else if( newpos > oldpos)
	    {
	        for (int i = oldpos; i < newpos; i++)
	        {
	            //D3("MyTreeCtrl::moveDevice() up to ("<<newpos<<")(" << i << ")(" << i+1 << ")");
    	        _deviceList.Swap(i,i+1);
	        }
	    }
	    return true;
	}
	else
	{
		D3("MyTreeCtrl::moveDevice( ..) index out of border ");
		return false;
	}
}

bool MyTreeCtrl::createDevice(int handle)
{
    Devices * newDevice = new Devices(handle, "0.0.0.0");
    newDevice->setName(Sprintf("number: %3d",_counter));
    newDevice->setParent(0);
    _deviceList.Add();
    _deviceList[_deviceList.GetCount()-1] = newDevice;

    setmodifiedDevice(true);
    _counter++;

}

GUI_APP_MAIN
{
	MyTreeCtrl().Run();
}

