#include <CtrlLib/CtrlLib.h>

#include "bench.h"

using namespace Upp;



////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////

struct App : TopWindow {
	Point p;

	virtual void MouseMove(Point _p, dword keyflags) {
		p = _p;
		Refresh();
	}

	virtual void Paint(Draw& w) {
		RTIMING("Paint");
		Size sz = GetSize();
		ImageBuffer ib(sz);
		Fill(~ib, White(), ib.GetLength());
		
		SDraw *swP = NULL;
		Cairo *caP = NULL;
		
		#if 1
		SDraw sw(ib);
		swP = &sw;
		#else
		Cairo ca;
		ca.SetSurface(ib);
		caP = &ca;
		#endif
		
		//PaintLion(swP, caP, NULL);
		DrawPythagorasTree(GetSize(), swP, caP);
		
		w.DrawImage(0, 0, ib);
	}
	
	App() { Sizeable().Zoomable(); p = Point(0, 0); }
};

/*#include <plugin/cairo/CairoCtrl.h>
struct TestCairoCtrl : CairoCtrl {
	Point p;

	virtual void MouseMove(Point _p, dword keyflags) {
		p = _p;
		Refresh();
	}
	
	virtual void CairoPaint(Cairo &ca) {
		RTIMING("CairoPaint");
		
		ca.Clear(White());
		PaintLion(NULL, &ca, NULL);
	}
};

struct App2 : TopWindow {
	TestCairoCtrl ctrl;

	void CairoPaint(Cairo& ca) {
	}
	
	App2() { 
		Sizeable().Zoomable(); 
		
		ctrl.SizePos();
		Add(ctrl);
	}
};*/

GUI_APP_MAIN
{
	App().Run();
}
