#include "bench.h"

//http://cgit.freedesktop.org/cairo/plain/perf/pythagoras-tree.c
void AddRect(Cairo &c, double size)
{
	if (size < 1)
		return;
	
	Pointf p = c.GetCurrentPoint();
	
	c.RelMoveTo(-size/2., -size/2.);
	c.RelLineTo(size, 0);
	c.RelLineTo(0, size);
	c.RelLineTo(-size, 0);
	c.ClosePath();
	
	c.Save();
	c.Translate(-size/2., size);
	c.MoveTo(p.x, p.y);
	c.Rotate(M_PI/4.);
	AddRect(c, size / M_SQRT2);
	c.Restore();
	
	c.Save();
	c.Translate(size/2., size);
	c.MoveTo(p.x, p.y);
	c.Rotate(-M_PI/4.);
	AddRect(c, size / M_SQRT2);
	c.Restore();
}

void AddRect(SDraw &sw, double size, Pointf p)
{
	if (size < 1)
		return;
	
	Pointf p2(-size/2., -size/2.);
	p2 += p;
	sw.Move(p2.x, p2.y);
	sw.Line(p2.x + size, p2.y);
	sw.Line(p2.x + size, p2.y + size);
	sw.Line(p2.x, p2.y + size);
	sw.Line(p2.x, p2.y);
	sw.Fill(Black());
	//sw.Close();
	
	sw.Begin();
	sw.Translate(-size/2., size);
	sw.Move(p.x, p.y);
	sw.Rotate(M_PI/4.);
	AddRect(sw, size / M_SQRT2, p);
	sw.End();
	
	sw.Begin();
	sw.Translate(size/2., size);
	sw.Move(p.x, p.y);
	sw.Rotate(-M_PI/4.);
	AddRect(sw, size / M_SQRT2, p);
	sw.End();
}

void DrawPythagorasTree(Size sz, SDraw *sw, Cairo *ca)
{
	double size = 128;
	
	if (sw)
	{
		sw->Begin();
		sw->Translate(0, sz.cy);
		sw->Scale(1, -1);
		
		Pointf p(sz.cx/2, size/2);
		AddRect(*sw, size, p);
		sw->Fill(Black());
		sw->End();
	}
	
	if (ca)
	{
		ca->Save();
		ca->Translate(0, sz.cy);
		ca->Scale(1, -1);
		
		ca->MoveTo(sz.cx/2, size/2);
		AddRect(*ca, size);
		ca->SetSourceRGB(Black());
		ca->Fill();
		ca->Restore();
	}
}