# -*- coding: cp1250 -*-

import socket, traceback

from threading import Lock

from mylib import MyError
from mylib import printLog, withLock

#---------------------------------------------------------------
BUFSIZE = 2048

INVALID_ARGUMENT  = 10022
NOT_WO_BLOCKING   = 10035
ALREADY_IN_USE    = 10048
RESET_BY_PEER     = 10054
ALREADY_CONNECTED = 10056

#---------------------------------------------------------------
class TcpConn(object):
    def __init__(self):
        self._lock = Lock()
        #
        self.connected = False
        self.receivedCnt = 0
        self.sentCnt = 0
        self.changed = True
        #
        self.running = False
    def init(self, conns):
        self.conns = conns
        
    def setChanged(self):
        self.changed = True
    def incReceivedCnt(self):
        self.receivedCnt += 1
        if self.receivedCnt > 1000000:
            self.receivedCnt = 0
        self.setChanged()
    def incSentCnt(self):
        self.sentCnt += 1
        if self.sentCnt > 1000000:
            self.sentCnt = 0
        self.setChanged()

    @withLock
    def run(self):
        pass
    @withLock
    def getChanged(self):
        ret = self.changed, self.receivedCnt, self.sentCnt
        self.changed = False
        return ret
    @withLock
    def resetCnts(self):
        self.receivedCnt = 0
        self.sentCnt = 0
        self.setChanged()

    def doRoutes(self):
        while self.receivedDatas != []:                         # je co preroutovat ?
            data = self.receivedDatas.pop(0)                    # co to bude
            tos = list(self.connIndsToSend)                     # kam to bude
            while tos != []:
                connInd = tos.pop(0)
                if not connInd < len(self.conns):
                    continue
                self.conns[connInd].send(data)

    def send(self, data):
        self.datasToSend.append(data)

#---------------------------------------------------------------
class TcpServer(TcpConn):
    typeStr = 'S'

    def __init__(self, 
        descrStr, localPort, 
        connIndsToSend, enabled
    ):
        TcpConn.__init__(self)
        #
        self.descrStr = descrStr
        self.localPort = localPort
        self.connIndsToSend = connIndsToSend
        self.enabled = enabled
        #
        self.receivedDatas = []
        self.datasToSend = []
        self.listening = False
    def setCfg(self, 
        descrStr, localPort, 
        connIndsToSend, enabled
    ):
        if (self.enabled != enabled or 
            self.localPort != localPort
        ):
            self.closeListen()
        self.descrStr = descrStr
        self.localPort = localPort
        self.connIndsToSend = connIndsToSend
        self.enabled = enabled
    def toggleEnabled(self):
        self.enabled = not self.enabled

    def getCfgRepr(self):
        return "TcpServer('%s', %d, %s, %s)" % (
            self.descrStr, self.localPort, self.connIndsToSend, self.enabled
        )

    def listen(self):
        try:
            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            s.bind(('', self.localPort))
            s.listen(1)
            s.settimeout(0.0)
            self.st_listen = s
            self.listening = True
        except socket.error, e:
            if e[0] == ALREADY_IN_USE:
                pass

    def accept(self):
        try:
            st, tcp_addr = self.st_listen.accept()
            self.remoteIP, self.remotePort = tcp_addr
            st.settimeout(0.0)
            st.setsockopt(socket.SOL_SOCKET, socket.SO_KEEPALIVE, 1)
            self.st = st
            self.connected = True
            self.setChanged()
            printLog('Connected from %s:%d on port %d\n' % (
                self.remoteIP, self.remotePort, self.localPort
            ))
        except socket.error, e:
            if e[0] == NOT_WO_BLOCKING:
                pass
            else:
                self.st_listen.close()
                self.listening = False
        except:
            raise

    def close(self):
        if self.connected:
            printLog('Closed on port %d\n' % self.localPort)
            self.connected = False
            self.st.close()
        self.setChanged()
    def closeListen(self):
        if self.listening:
            self.listening = False
            self.st_listen.close()

    #-----------------------------------------------
    @withLock
    def activate(self):
        self.running = True

    @withLock
    def deactivate(self):
        self.close()
        self.running = False

    @withLock
    def run(self):
        if not self.enabled or not self.running:
            return
        try:
            if not self.listening:                              # listen ?
                self.listen()
            elif not self.connected:                            # accept ?
                self.accept()
            if self.connected:                                  # mozno prijat data ?
                try:
                    data = self.st.recv(BUFSIZE)
                    if len(data) == 0:
                        self.close()
                        return
                    else:
                        self.receivedDatas.append(data)
                        self.incReceivedCnt()
                except socket.error, e:
                    if e[0] == RESET_BY_PEER:
                        self.close()
                        return
        except:
            traceback.print_exc()
        #
        self.doRoutes()                                         # preroutuj na ostatne objekty
        #
        if self.datasToSend != []:                              # vysli data ?
            if self.connected:
                try:
                    data = self.datasToSend[0]
                    self.st.send(data)
                    self.datasToSend.pop(0)
                    self.incSentCnt()
                except socket.error, e:
                    if e[0] == RESET_BY_PEER:
                        self.close()
                        return
                except:
                    self.close()
                    return
            else:
                self.datasToSend.pop(0)

#---------------------------------------------------------------
class TcpClient(TcpConn):
    typeStr = 'C'

    def __init__(self, 
        descrStr, remoteIP, remotePort, 
        connIndsToSend, enabled
    ):
        TcpConn.__init__(self)
        #
        self.descrStr = descrStr
        self.remoteIP = remoteIP
        self.remotePort = remotePort
        self.connIndsToSend = connIndsToSend
        self.enabled = enabled
        #
        self.receivedDatas = []
        self.datasToSend = []
        self.connecting = False
    def setCfg(self, 
        descrStr, remoteIP, remotePort, 
        connIndsToSend, enabled
    ):
        self.descrStr = descrStr
        self.remoteIP = remoteIP
        self.remotePort = remotePort
        self.connIndsToSend = connIndsToSend
        self.enabled = enabled
    def toggleEnabled(self):
        self.enabled = not self.enabled

    def getCfgRepr(self):
        return "TcpClient('%s', '%s', %d, %s, %s)" % (
            self.descrStr, self.remoteIP, self.remotePort, 
            self.connIndsToSend, self.enabled
        )

    def connect(self):
        try:
            if not self.connecting:
                st = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                st.bind(('', 0))
                st.settimeout(0.0)
                st.setsockopt(socket.SOL_SOCKET, socket.SO_KEEPALIVE, 1)
                self.st = st
                self.connecting = True
            else:
                if self.remoteIP.startswith('#'):
                    connInd = int(self.remoteIP[1:])
                    if not connInd < len(self.conns):
                        return
                    if not self.conns[connInd].connected:
                        return
                    remoteIP = self.conns[connInd].remoteIP
                else:
                    remoteIP = self.remoteIP
                self.st.connect((remoteIP, self.remotePort))
        except socket.error, e:
            if e[0] == NOT_WO_BLOCKING:
                pass
            elif e[0] == ALREADY_CONNECTED:
                self.localPort = self.st.getsockname()[1]
                self.connected = True
                self.setChanged()
                printLog('Connected to %s:%d on port %s\n' % (
                    remoteIP, self.remotePort, self.localPort
                ))
            elif e[0] == INVALID_ARGUMENT:
                pass
            else:
                traceback.print_exc()
                self.st.close()
                self.connecting = False
        except:
            raise

    def close(self):
        if self.connected or self.connecting:
            if self.connected:
                printLog('Closed on port %d\n' % self.st.getsockname()[1])
            self.connected = False
            self.connecting = False
            self.st.close()
        self.setChanged()

    #-----------------------------------------------
    @withLock
    def activate(self):
        self.running = True

    @withLock
    def deactivate(self):
        self.close()
        self.running = False

    @withLock
    def run(self):
        if not self.enabled or not self.running:
            return
        try:
            if not self.connected:                              # connected ?
                self.connect()
            if self.connected:                                  # mozno prijat data ?
                try:
                    data = self.st.recv(BUFSIZE)
                    if len(data) == 0:
                        self.close()
                        return
                    else:
                        self.receivedDatas.append(data)
                        self.incReceivedCnt()
                except socket.error, e:
                    if e[0] == RESET_BY_PEER:
                        self.close()
                        return
        except:
            traceback.print_exc()
        #
        self.doRoutes()                                         # preroutuj na ostatne objekty
        #
        if self.datasToSend != []:                              # vysli data ?
            if self.connected:
                try:
                    data = self.datasToSend[0]
                    self.st.send(data)
                    self.datasToSend.pop(0)
                    self.incSentCnt()
                except socket.error, e:
                    if e[0] == RESET_BY_PEER:
                        self.close()
                        return
                except:
                    self.close()
                    return
            else:
                self.datasToSend.pop(0)

#---------------------------------------------------------------
CFG_HEAD_TMPL = '''\
# -*- coding: cp1250 -*-

from tcproute import TcpServer, TcpClient, ConnsTable

connsTable = ConnsTable(
'''

CFG_TAIL_TMPL = '''\
)
'''

class ConnsTable():
    def __init__(self, *conns):
        self.conns = list(conns)
        for conn in self.conns:
            conn.init(self.conns)

    def setCfg(self, 
            id, typeStr, descrStr, 
            localPortStr, remotePortStr,
            routeStr, enabled
        ):
        conn = self.conns[id]
        #
        if typeStr == 'S':
            try:
                localPort = int(localPortStr)
                exec 'route = %s' % routeStr
                if not isinstance(conn, TcpServer):
                    self.conns[id] = TcpServer(
                        descrStr, localPort, route, enabled
                    )
                    self.conns[id].init(self.conns)
                else:
                    conn.setCfg(
                        descrStr, localPort, route, enabled
                    )
            except:
                return False
            return True
        elif typeStr == 'C':
            try:
                remoteIPStr, remotePortStr = remotePortStr.split(':')
                remoteIPStr.strip()
                if remoteIPStr.startswith('#'):
                    connInd = int(remoteIPStr[1:])
                    remoteIP = '#%d' % connInd
                else:
                    a, b, c, d = remoteIPStr.split('.')
                    a, b, c, d = int(a), int(b), int(c), int(d)
                    remoteIP = '%d.%d.%d.%d' % (a, b, c, d)
                remotePort = int(remotePortStr)
                exec 'route = %s' % routeStr
                if not isinstance(conn, TcpClient):
                    self.conns[id] = TcpClient(
                        descrStr, remoteIP, remotePort, route, enabled
                    )
                    self.conns[id].init(self.conns)
                else:
                    conn.setCfg(
                        descrStr, remoteIP, remotePort, route, enabled
                    )
            except:
                return False
            return True
        return False
    def toggleEnabled(self, id):
        conn = self.conns[id]
        conn.toggleEnabled()

    def resetCnts(self):
        for conn in self.conns:
            conn.resetCnts()

    def getCfgRepr(self):
        str = CFG_HEAD_TMPL
        for conn in self.conns:
            str += '    ' + conn.getCfgRepr() + ',\n'
        str += CFG_TAIL_TMPL
        return str

    def saveCfg(self):
        ERROR_STR = "Chyba zpisu do sboru '%s'"
        #
        cfgFileName = 'cfg\\connsrvcfg.py'
        backupFileName = cfgFileName + '~'
        try:
            os.remove(backupFileName)
        except:
            pass
        try:
            os.rename(cfgFileName, backupFileName)
        except:
            pass
        #
        try:
            fw = file(cfgFileName, 'wt')
            try:
                fw.write(self.getCfgRepr())
            finally:
                fw.close()
        except:
            raise MyError(ERROR_STR %  cfgFileName)

    def activate(self):
        for conn in self.conns:
            conn.activate()

    def deactivate(self):
        for conn in self.conns:
            conn.deactivate()

    def remove(self, id):
        self.conns[id : id + 1] = []
    def addNewItem(self):
        self.conns.append(TcpConn())
        self.conns[-1].init(self.conns)
    def moveUp(self, id):
        a, b = self.conns[id - 1 : id + 1]
        self.conns[id - 1 : id + 1] = b, a
    def moveDown(self, id):
        a, b = self.conns[id : id + 2]
        self.conns[id : id + 2] = b, a
