#ifndef _connsrv_connsrv_h
#define _connsrv_connsrv_h

#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#include "pyconnsrv.h"

#define LAYOUTFILE <connsrv/connsrv.lay>
#include <CtrlCore/lay.h>

//---------------------------------------------------------------------------
class ConnsTable : public WithConnsTableLayout<ParentCtrl> {
public:
    typedef ConnsTable CLASSNAME;
    
    ConnsTable(void);
    void init(const PxObject& conns);
    void tstChanged(void);
    
    void buttonResetCntsClick(void);
    void optionEditableChanged(void);
    void buttonSaveChangesClick(void);
    void buttonActivateClick(void);
    void buttonDeactivateClick(void);
    
    void whenStartEdit(void);
    bool whenAcceptRow(void);
    void whenOptionEnabledChanged(Option *self);
    void whenUpdateRow(void);    
    void dropTypeChanged(void);
    
    void contextMenu(Bar &bar);
    void onEditItem(int id);
    void onRemoveItem(int id);
    void onAddNewItem(void);
    void onMoveUp(int id);
    void onMoveDown(int id);
protected:
    PxObject xConnsTable;
    
    DropList  dropType;
    EditField editDescr;
    EditField editLocalPort;
    EditField editRemotePort;
    EditField editRoute;    
    
    Array<Option*> optionsEnabled;
    
    void addNewItem(int id, const PxObject& xConn);
};

//---------------------------------------------------------------------------
class Connsrv : public WithConnsrvLayout<TopWindow> {
public:
    typedef Connsrv CLASSNAME;
    Connsrv(const PxObject& xRun_, const PxObject& xConnsTable_);
    virtual bool Accept();
    
    ConnsTable connsTable;
protected:
    PxObject xRun;
    PxObject xConnsTable;
    Thread thr;
    
    void exit(void);
    void timerRun(void);
    void tstNewPrintLog(void);
    void pyRun(void);
};

#endif

