#include "pyconnsrv.h"

#include <Core/Core.h>
using namespace Upp;

//---------------------------------------------------------------------------
PyThreadState* mainThreadState = NULL;

PxObject xNone, xMain, xStdErr;
PxObject xTcpServer, xTcpClient;

//---------------------------------------------------------------------------
static PyMethodDef pyconnsrvMethods[] = {
    {NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC initpyconnsrv(void)
{
    (void) Py_InitModule(const_cast<char*>("pyconnsrv"), pyconnsrvMethods);
}

//---------------------------------------------------------------------------
void pythonInit(void) {
    const char* execStr = "execfile('connsrv.py')";

    Py_InitializeEx(0);
    PyEval_InitThreads();
    mainThreadState = PyThreadState_Get();

    xNone = Py_None;
    xMain = xNone;
    xStdErr = xNone;
    
    xTcpServer = xNone;
    xTcpClient = xNone;
    
    try {
        initpyconnsrv();
        
        PxRun_SimpleString(execStr);
        
        xMain   = PxImport_AddModule("__main__");
        xStdErr = xMain("sys")("stderr");
        
        xTcpServer = xMain("TcpServer");
        xTcpClient = xMain("TcpClient");
    }
    catch (PxException& e) {
        LOG_PX_TRACEBACK;
    }
    catch (...) {}
    
    PyThreadState_Swap(NULL);
    PyEval_ReleaseLock();
}

void pythonFinalize(void) {
    PyEval_AcquireLock();
    PyThreadState_Swap(mainThreadState);
    
    xNone.invalidate();
    xMain.invalidate();
    xStdErr.invalidate();
    
    xTcpServer.invalidate();
    xTcpClient.invalidate();
    
    Py_Finalize();
}

//---------------------------------------------------------------------------
void logPxTraceback(
     PxObject& xStdErr, PxException& e, const char* file, int line
) 
{
    static bool hasAttr = true;
    
    try {
        try {
            if (xStdErr.HasAttr("timeStamp")) {
                hasAttr = true;
                xStdErr("timeStamp").Call();
                xStdErr("write").CallArgs(
                    PxString(Format("%s, line %d\n", file, line).Begin())
                );
                e.printTraceback();
            }
            else {
                if (hasAttr)
                    RLOG("Error writing traceback: 'sys.stderr' hasn't attribute 'timeStamp'");
                hasAttr = false;
            }
        }
        catch (...) {
            RLOG("Error writing traceback: exception in 'logPxTraceback'");
        }
     }
     catch (...) {
     }
}
