import datetime, sys

try:
    import threading as threading
except ImportError:
    import dummy_threading as threading

#---------------------------------------------------------------
class MyError(Exception):
    def __init__(self, text = 'Without description'):
        self.args = (text,)

class MyAError(MyError):
    def __init__(self, text, value):
        self.args = (text, value)

#---------------------------------------------------------------
def withLock(f):
    def f_(self, *args, **kws):
        self._lock.acquire()
        try:
            v = f(self, *args, **kws)
        finally:
            self._lock.release()
        return v
    return f_

#---------------------------------------------------------------
class PrintLog:
    def __init__(self):
        self._lock = threading.RLock()
        self._toPrint = []
        self._nextOnNewLine = True
    def lock(self):
        self._lock.acquire()
    def unlock(self):
        self._lock.release()
    @withLock
    def __call__(self, str):
        self.timeStamp()
        #
        strs = str.split('\n')
        for s in strs[:1]:
            if self._nextOnNewLine:
                self._toPrint.append(s)
            else:
                self._toPrint[-1] += s
        for s in strs[1:]:
            self._toPrint.append(s)
        self._nextOnNewLine = True
    @withLock
    def write(self, str):
        nextOnNewLine = False
        if str.endswith('\n'):
            str = str[:-1]
            nextOnNewLine = True
        #
        strs = str.split('\n')
        for s in strs[:1]:
            if self._nextOnNewLine:
                self._toPrint.append(s)
            else:
                self._toPrint[-1] += s
        for s in strs[1:]:
            self._toPrint.append(s)
        self._nextOnNewLine = nextOnNewLine
    @withLock
    def timeStamp(self):
        dt = datetime.datetime.today()
        dt = datetime.datetime(
            dt.year, dt.month, dt.day,
            dt.hour, dt.minute, dt.second
        )
        self._toPrint.append('\n%s > ' % dt)
        self._nextOnNewLine = False
    @withLock
    def getAll(self):
        if self._nextOnNewLine:
            toPrint = self._toPrint
            self._toPrint = []
        else:
            toPrint = self._toPrint[:-1]
            self._toPrint = [self._toPrint[-1]]
        return toPrint
    @withLock
    def printAll(self):
        print self.getAll()

def printLog(str):
    if hasattr(sys.stderr, 'timeStamp'):
        sys.stderr.timeStamp()
    print >> sys.stderr, str

