#ifndef _CORE_alt_MTalt_h_
#define _CORE_alt_MTalt_h_

#include <Core/Core.h>
using namespace Upp;

class CallbackQueue
{
public:
	CallbackQueue() 
		:shuttingDown(false)
	{
	}
	
	~CallbackQueue()
	{
		qMutex.Enter();
		queue.Clear();
		qMutex.Leave();
	}
	
	template<class OBJECT>
	void Add(void (OBJECT::*m)())
	{
		Element0<OBJECT> *e = new Element0<OBJECT>;
		e->caller = static_cast<OBJECT *>(this);
		e->m  = m;
		qMutex.Enter();
		queue.AddTail(e);
		qMutex.Leave();
		qSemaphore.Release();
	}
	
	template<class OBJECT, class P1>
	void Add(void (OBJECT::*m)(const P1 &), const P1 &p1)
	{
		Element1<OBJECT, P1> *e = new Element1<OBJECT, P1>;
		e->caller = static_cast<OBJECT *>(this);
		e->m  = m;
		e->p1 = p1;
		qMutex.Enter();
		queue.AddTail(e);
		qMutex.Leave();
		qSemaphore.Release();
	}
	
	template<class OBJECT, class P1, class P2>
	void Add(void (OBJECT::*m)(const P1 &,const P2 &), const P1 &p1, const P2 &p2)
	{
		Element2<OBJECT, P1, P2> *e = new Element2<OBJECT, P1, P2>;
		e->caller = static_cast<OBJECT *>(this);
		e->m  = m;
		e->p1 = p1;
		e->p2 = p2;
		qMutex.Enter();
		queue.AddTail(e);
		qMutex.Leave();
		qSemaphore.Release();
	}
	
	void DoTasks()
	{
		while (!shuttingDown)
			if (!Execute())
				return;
	}
	
	void WaitDoTasksInf()
	{
		while (!shuttingDown)
		{
			qSemaphore.Wait();
			Execute();
		}
	}

	void RequestShutdownAwake()
	{
		if (!shuttingDown)
		{
			shuttingDown = true;
			Add(&CallbackQueue::DoNothingJustAwake);
		}
	}
	
	bool IsShuttingDown() { return shuttingDown; }
	int GetTaskCount() {qMutex.Enter(); int out=queue.GetCount(); qMutex.Leave(); return out;}
	
private:
	bool Execute()
	{
		qMutex.Enter();
		if (queue.IsEmpty())
		{
			qMutex.Leave();
			return false;
		}
		
		Element *e = queue.DetachHead();
		qMutex.Leave();
		e->Execute();
		delete e;
		return true;
	}
	
	struct Element
	{
		virtual ~Element() {}
		virtual void Execute() const = 0;
		void *caller;
	};
	
	template<class OBJECT>
	struct Element0 : public Element
	{
		virtual ~Element0() {}
		virtual void Execute() const {((static_cast<OBJECT *>(caller))->*m)();}
		void (OBJECT::*m)();
	};
	
	template<class OBJECT, class P1>
	struct Element1 : public Element
	{
		virtual ~Element1() {}
		virtual void Execute() const {((static_cast<OBJECT *>(caller))->*m)(p1);}
		void (OBJECT::*m)(const P1 &p1);
		P1 p1;
	};
	
	template<class OBJECT, class P1, class P2>
	struct Element2 : public Element
	{
		virtual ~Element2() {}
		virtual void Execute() const {((static_cast<OBJECT *>(caller))->*m)(p1,p2);}
		void (OBJECT::*m)(const P1 &p1, const P2 &p2);
		P1 p1;
		P2 p2;
	};
	
	void DoNothingJustAwake(){}

	BiArray<Element> queue;
	Mutex            qMutex;
	Semaphore        qSemaphore;
	bool             shuttingDown;
};

class CallbackThread : public CallbackQueue, protected Thread
{
public:
	CallbackThread() {Thread::Run(callback(this, &CallbackThread::Run));}
	~CallbackThread() {RequestShutdownAwake(); Wait();}
	void Run() {WaitDoTasksInf();}
};

#endif
