/*  HexGridCtrl
 * 	8.4.2008 Radek Hascak
 */

#ifndef _Hexagon_HexGrid_h_
#define _Hexagon_HexGrid_h_

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

class HexGridCtrl : public Ctrl {
public:
	HexGridCtrl();
	
	Callback3<Draw&, int, int> OnDrawHex;
	Callback2<Point&, dword> OnLeftDown;
	Callback2<Point&, dword> OnRightDown;
	
protected:	
	virtual void Paint(Draw& w);
	virtual void Layout();
	virtual void LeftDown(Point p, dword flags);
	virtual void RightDown(Point p, dword flags);
	
public:	
	void DrawHex(Draw& draw, int x, int y, Color color);
	void DrawHex(Draw& draw, int x, int y, const Image& img);
		
	void DrawHex(Draw& draw, int x, int y);
	void DrawHex(Draw& draw, int x, int y, const String& s, Font font = StdFont(),
				 Color ink = DefaultInk);
	
	HexGridCtrl& SetRows(int iRows);
	HexGridCtrl& SetColumns(int iCols);
	HexGridCtrl& SetEdgeSize(int iSize);
	HexGridCtrl& ShowGrid(bool b = true) { m_bGrid = b; return *this;}
	HexGridCtrl& ScrollShow(bool b = true) { m_cScroll.AutoHide(b); m_cScroll.Show(b); return *this;}

	Image Cut(const Image& img);
	
	inline Point Screen2Hex(const Point& p);
	Point Hex2Screen(const Point& p);
	
	Point Screen2HexPart(const Point& p);

	Size GetScrollTotal() { return Size(2*m_iR*m_iCols+m_iR, (m_iH+m_iS)*m_iRows + m_iH); }
	
protected:
	void Scroll();
	void SetupSize();

private:
	Vector<Point> m_vHex;	
	int m_iR, m_iH, m_iS;
	int m_iRows, m_iCols;
	Drawing m_cDwHex;

	ScrollBars m_cScroll;

	bool	m_bGrid;
	
//colors
public:
	HexGridCtrl& Paper(Color c)    { m_cPaper = c; Refresh(); return *this; }

private:
	Color m_cPaper;
};



#endif
