#ifndef _HexBombs_HexBombs_h
#define _HexBombs_HexBombs_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#include "HexGridCtrl.h"

#define IMAGEFILE <HexBombs/HexBombs.iml>
#include <Draw/iml_header.h>

class HexBombs : public TopWindow {
public:
	typedef HexBombs CLASSNAME;
	HexBombs();

	void HexLeftDown(Point& p, dword flags);
	void HexRightDown(Point& p, dword flags);
	
protected:		
	void OnDrawHex(Draw& draw, int x, int y);

	enum {
		HIDDEN = 16,
		BOMB = 32,
		MARK = 64,
		EXPLODED = 128,

		UNIT = 25,
	};

	void About();

	void File(Bar& menu);
	void Game(Bar& menu);
	void Menu(Bar& menu);
	void MenuDraw(Bar& menu);

	void SetDraw(bool bSet = false);
	void ShowStatus();
	void Level(Size sz);
	void Generate();
	void Uncover(int x, int y);
	void UncoverAll();
	int Neighbours(int x, int y);

	byte& Field(int x, int y) { return field[x + y * cx]; }
	
	int          	cx, cy;
	int          	normal_cells, bombs;
	Buffer<byte> 	field;
	Size 			level;	
	
	StatusBar    	status;
	MenuBar 		menu;
	HexGridCtrl 	grid;
	
	bool			m_bDraw;
};

#endif

