/*  HexGridCtrl
 * 	8.4.2008 Radek Hascak
 */
#include <time.h> 
#include "HexBombs.h"

#define IMAGEFILE <HexBombs/HexBombs.iml>
#include <Draw/iml_source.h>

void HexBombs::OnDrawHex(Draw& draw, int x, int y)
{
	byte f = Field(x, y);
	Color cross = Null;
	Color ink = SBlack;
	String txt;
	
	if (m_bDraw)
	{
		if (f & MARK)
			grid.DrawHex( draw, x, y, IMAGECLASS::Mark() );
		else if (f & HIDDEN)
			grid.DrawHex( draw, x, y, IMAGECLASS::Deck() );
		else if (f & EXPLODED)
			grid.DrawHex( draw, x, y, IMAGECLASS::BombExp() );
		else if (f & BOMB)
			grid.DrawHex( draw, x, y, IMAGECLASS::Bomb() );
		else 
		{
			grid.DrawHex( draw, x, y, SLtGray() );
			f = f & 15;
			txt = String(f + '0', 1);		
			
			switch (f&15)
			{
				case 1 : ink = SLtBlue;	break;
				case 2 : ink = SGreen; 	break;
				case 3 : ink = SLtRed; 	break;
				case 4 : ink = Blue; 	break;
				case 5 : ink = Green; 	break;
				case 6 : ink = Black; 	break;
			}
			
			if (ink)
				grid.DrawHex(draw, x, y, txt, Arial(UNIT), ink);
		}	
		
		if (normal_cells==0)
		{
			if (f & MARK)
			{
				if (f & BOMB)
					grid.DrawHex( draw, x, y, IMAGECLASS::Mark() );
				else
					cross = SLtRed;
			}
		}
	}
	else
	{
		grid.DrawHex(draw, x, y, (f & (HIDDEN|MARK)) ? SLtGray : f & BOMB ? SLtRed : SWhite);
	
		if(f & MARK)
		{
			txt = "M";
			ink = SLtRed;
			if((f & (HIDDEN|BOMB)) == BOMB) {
				ink = SLtBlue;
				cross = SLtRed;
			}
		}
		else
			if(!(f & HIDDEN))
				if(f & BOMB)
					txt = "B";
				else
				{
					f = f & 15;
					txt = String(f + '0', 1);
					ink = f == 0 ? SLtGreen : f == 1 ? SLtBlue : SBlack;
				}
	
		grid.DrawHex(draw, x, y, txt, Roman(UNIT), ink);

		if(f & EXPLODED)
			cross = SLtBlue;

	}

	if (cross)
	{
		Size size(2*UNIT*86/100, 2*UNIT);
		ImageDraw iw(size.cx, size.cy);

		iw.Alpha().DrawLine(size.cx>>2, UNIT>>2, size.cx-(size.cx>>2), size.cy-(UNIT>>2), 2, GrayColor(255));
		iw.Alpha().DrawLine(size.cx>>2, size.cy-(UNIT>>2), size.cx-(size.cx>>2), UNIT>>2, 2, GrayColor(255));

		iw.DrawRect(0, 0, size.cx, size.cy, cross);

		grid.DrawHex( draw, x, y, grid.Cut(iw));
	}
}

void HexBombs::HexLeftDown(Point& p, dword flags)
{
	if(!normal_cells)
		return;

	Uncover(p.x, p.y);
	Refresh();
	ShowStatus();
}

void HexBombs::HexRightDown(Point& p, dword flags)
{
	if(!normal_cells)
		return;

	if(Field(p.x, p.y) & HIDDEN) {
		Field(p.x, p.y) ^= MARK;
		Refresh();
	}
}

void HexBombs::UncoverAll()
{
	for(int i = cx * cy - 1; i >= 0; i--)
		field[i] &= ~HIDDEN;
	Refresh();
}

void HexBombs::Uncover(int x, int y)
{
	
	if(x >= 0 && x < cx && y >= 0 && y < cy) {
		byte& f = Field(x, y);
		if((f & (HIDDEN|MARK)) == HIDDEN)
		{
			if(f & BOMB) {
				f |= EXPLODED;
				normal_cells = 0;
				UncoverAll();
				return;
			}
			//---
			if((f &= ~HIDDEN) == 0)
			{
				Uncover(x, y-1);
				Uncover(x-1, y);
				Uncover(x+1, y);
				Uncover(x, y+1);
				if (y&1)
				{
					Uncover(x+1,y-1);
					Uncover(x+1,y+1);
				} else {
					Uncover(x-1,y-1);
					Uncover(x-1,y+1);				
				}
			}
			//---
			normal_cells--;
			if(normal_cells == 0) {
				UncoverAll();
				PromptOK("[*@4A6 Nice!]&You have found all the bombs!");
			}
		}
	}
}

int HexBombs::Neighbours(int x, int y)
{
	int ret = 0;

	if ( y-1 >= 0 )
		ret += Field(x, y-1) & BOMB;
	
	if ( x-1 >= 0)
		ret += Field(x-1,y) & BOMB;
	
	if ( x+1 < cx)
		ret += Field(x+1,y) & BOMB;
	
	if ( y+1 < cy)
		ret += Field(x,y+1) & BOMB;
	
	if ( y & 1)
	{
		if ( (x+1 < cx) && (y-1 >= 0) )
			ret += Field(x+1,y-1) & BOMB;
		if ( (x+1 < cx) && (y+1 < cy) )
			ret += Field(x+1,y+1) & BOMB;
	} else
	{
		if ( (x-1 >= 0) && (y-1 >= 0) )
			ret += Field(x-1,y-1) & BOMB;
		if ( (x-1 >= 0) && (y+1 < cy) )
			ret += Field(x-1,y+1) & BOMB;
	}
	
	ret /= BOMB;	
	    	
	return ret;
}


void HexBombs::Generate()
{
	cx = level.cx;
	cy = level.cy;
	
	field.Alloc(cx * cy);
	
	for(int i = cx * cy - 1; i >= 0; i--)
		field[i] = (rand() & 15) < 3 ? HIDDEN|BOMB : HIDDEN;
	
	normal_cells = 0;
	for(int x = 0; x < cx; x++)
		for(int y = 0; y < cy; y++)
			if((Field(x, y) & BOMB) == 0)
			{
				normal_cells++;
				Field(x, y) += Neighbours(x,y);
			}

	bombs = cx * cy - normal_cells;

	grid.SetColumns(level.cx).SetRows(level.cy);
	
	Rect r = GetRect();

//	r.SetSize(AddFrameSize(grid.GetScrollTotal()) + Size(20,20));
//	SetRect(r);
	r.SetSize(AddFrameSize(grid.GetScrollTotal()));
	SetRect(r);

	ShowStatus();
	
	Refresh();
}

void HexBombs::ShowStatus()
{
	status = Format("%d bombs, %d cells remaining", bombs, normal_cells);
}

void HexBombs::Level(Size sz)
{
	level = sz;
//	Generate();
}

void HexBombs::About()
{
	PromptOK("[*A9/ HexBombs]&[A5 made from]&[*A7/ uBombs]&[A5 Ultimate`+`+ example]");
}

void HexBombs::SetDraw(bool bSet)
{
	m_bDraw = bSet;
//	grid.ShowGrid(!m_bDraw);
	Refresh();
}

void HexBombs::File(Bar& menu)
{
	menu.Add("Exit", Breaker(IDOK));
	menu.Separator();
	menu.Add("About..", THISBACK(About));
}

void HexBombs::Game(Bar& menu)
{
	menu.Add("Restart", THISBACK(Generate));
	menu.Separator();
	menu.Add("Easy", THISBACK1(Level, Size(10, 10)))
	    .Check(level.cx == 10);
	menu.Add("Medium", THISBACK1(Level, Size(15, 15)))
	    .Check(level.cx == 15);
	menu.Add("Difficult", THISBACK1(Level, Size(25, 20)))
	    .Check(level.cx == 25);
}

void HexBombs::MenuDraw(Bar& menu)
{
	menu.Add("Images", THISBACK1(SetDraw, true)).Check(m_bDraw);
	menu.Add("Drawing", THISBACK1(SetDraw, false)).Check(!m_bDraw);
}

void HexBombs::Menu(Bar& menu)
{
	menu.Add("File", THISBACK(File));
	menu.Add("Game", THISBACK(Game));
	menu.Add("Draw", THISBACK(MenuDraw));
}

HexBombs::HexBombs()
{
	srand((unsigned)time( NULL ));
	
	m_bDraw = true;
	level = Size(10, 10);
	
	AddFrame(menu);
	menu.Set(THISBACK(Menu));
	AddFrame(status);
	AddFrame(InsetFrame());
	Title("HexBombs");
		
//	Sizeable();

	*this
		<< grid.ShowGrid().Paper(Gray()).SetEdgeSize(UNIT).ScrollShow(false).SizePos();

	Generate();
	
	IMAGECLASS::Set(IMAGECLASS::I_Deck, grid.Cut(IMAGECLASS::Deck()));
	IMAGECLASS::Set(IMAGECLASS::I_Mark, grid.Cut(IMAGECLASS::Mark()));
	IMAGECLASS::Set(IMAGECLASS::I_Bomb, grid.Cut(IMAGECLASS::Bomb()));
	IMAGECLASS::Set(IMAGECLASS::I_BombExp, grid.Cut(IMAGECLASS::BombExp()));
	
	grid.OnDrawHex = THISBACK(OnDrawHex);
	grid.OnLeftDown = THISBACK(HexLeftDown);
	grid.OnRightDown = THISBACK(HexRightDown);
}

GUI_APP_MAIN
{
	HexBombs().Run();
}

