#include "HexGridCtrl.h"

HexGridCtrl::HexGridCtrl() :
	m_iRows(0),
	m_iCols(0),
	m_iS(10),
	m_bGrid(false),
	m_cPaper(White())
{
//	AddFrame(OutsetFrame());
//	AddFrame(InsetFrame());

	BackPaint();

	AddFrame(m_cScroll);
	
	m_cScroll.WhenScroll = callback(this, &HexGridCtrl::Scroll);
}

void HexGridCtrl::SetupSize()
{
	m_iR = 86 * m_iS / 100;  //cos(30)
	m_iH = m_iS >> 1;
	
	int a = m_iR << 1;
	int b = m_iS << 1;
	
	m_vHex.Clear();
	
	m_vHex
	 	<< Point(m_iR,0)
		<< Point(a, m_iH)
		<< Point(a, m_iS+m_iH)
		<< Point(m_iR, b)
		<< Point(0, m_iS+m_iH)
		<< Point(0, m_iH)
		<< Point(m_iR,0);
		
//drawingdraw
	DrawingDraw w(a+1, b+1);
	w.DrawPolyline(m_vHex, 7, 1, Black );
	m_cDwHex = w;

}

void HexGridCtrl::Layout()
{
	m_cScroll.SetTotal(GetScrollTotal());
	m_cScroll.SetPage(GetSize());
}

void HexGridCtrl::Scroll()
{
//	SetFocus();
	Refresh();
}

HexGridCtrl& HexGridCtrl::SetRows(int iRows)
{
	m_iRows = iRows;
	Layout();
	return *this;
}

HexGridCtrl& HexGridCtrl::SetColumns(int iCols)
{	m_iCols = iCols;
	Layout();
	return *this;
}

HexGridCtrl& HexGridCtrl::SetEdgeSize(int iSize)
{	
	m_iS = iSize;
	SetupSize();
	Layout();
	return *this;
}

void HexGridCtrl::Paint(Draw& w)
{
	Rect screen = GetSize();
	w.DrawRect(screen, m_cPaper);

	Point pos = m_cScroll;
	Point max = m_cScroll.GetTotal();
	
	int Cmin = (pos.x - m_iR) / (m_iR << 1);
	int Rmin = (pos.y - m_iH) / (m_iS + m_iH);

	int Cmax = m_iCols - (max.x - screen.Width() - pos.x - m_iR) / (m_iR << 1);
	int Rmax = m_iRows - (max.y - screen.Height() - pos.y - m_iH) / (m_iS + m_iH);
	
	Cmax = min(Cmax, m_iCols);
	Rmax = min(Rmax, m_iRows);
	
	int xh;
	int yh;
	
	w.Offset(-pos);

	for(int x=Cmin; x<Cmax; x++) 	//cols
		for(int y=Rmin; y<Rmax; y++)	//rows
		{
			OnDrawHex(w, x, y);
			
			if (m_bGrid)
				DrawHex(w, x, y);	//polyline
		}

	w.End();

}

void HexGridCtrl::DrawHex(Draw& draw, int x, int y)
{
	Point p = Hex2Screen(Point(x,y));
	
	draw.DrawDrawing(p.x, p.y, m_cDwHex.GetSize(). cx,m_cDwHex.GetSize().cy, m_cDwHex);
}

void HexGridCtrl::DrawHex(Draw& draw, int x, int y, const String& s, Font font,
	Color ink)
{
	Point p = Hex2Screen(Point(x,y));
	Size cSize = GetTextSize(s.Begin(), font);
	
	draw.DrawText(p.x + m_iR - cSize.cx/2, p.y + m_iS - cSize.cy/2, s, font, ink);
}


void HexGridCtrl::DrawHex(Draw& draw, int x, int y, Color color)
{
	Point p = Hex2Screen(Point(x,y));
	
	draw.Offset(p.x, p.y);
	
	draw.DrawPolygon(m_vHex, color);
	
	draw.End();
}

void HexGridCtrl::DrawHex(Draw& draw, int x, int y, const Image& img)
{
	Point p = Hex2Screen(Point(x,y));	

	draw.DrawImage(p.x, p.y, img);
}

Image HexGridCtrl::Cut(const Image& img)
{
	int a = m_iR << 1;
	int b = m_iS << 1;
	
	ImageDraw cImg(a+1, b+1);

	cImg.Alpha().DrawPolygon(m_vHex, GrayColor(255));
	
	ImageBuffer cImBuf(cImg);


	int Xmax = min(a, img.GetWidth());
	int Ymax = min(b, img.GetHeight());

	for(int y = 0; y < Ymax; y++) {

		RGBA *d = cImBuf[y];
		const RGBA *s = img[y];

		for(int x = 0; x < Xmax; x++)
		{
			if (d->a)
			{
					*d = *s;
			}
			
			d++;
			s++;
		}
	}
		
	return cImBuf;
}

Point HexGridCtrl::Screen2HexPart(const Point& p)
{
	Point HexPart;
	Point pos = m_cScroll;

//row
	int x = (p.x + pos.x) % (m_iR);
	int xh = (p.x + pos.x) / (m_iR);
	
	HexPart.x = 2* xh;
	
	if (xh)
		HexPart.x++;
	
//col	
	int y = (p.y + pos.y) % (m_iH + m_iS);
	int yh = (p.y + pos.y) / (m_iH + m_iS);
	
	HexPart.y = 2*yh;
	
	if (yh > m_iH)
		HexPart.y++;
			
	return HexPart;
}

Point HexGridCtrl::Screen2Hex(const Point& p)
{
	Point Hex;
	Point pos = m_cScroll;

//col	
	int x;
	int xh;
	
//row	
	int y = (p.y + pos.y) % (m_iH + m_iS);
	int yh = (p.y + pos.y) / (m_iH + m_iS);
	
	//todo: shift it to member values
	double m = m_iH / (double)m_iR;
	
	if ( (yh & 1)) //B
	{
		x = (p.x + pos.x + m_iR) % (m_iR << 1);
		xh = (p.x + pos.x + m_iR) / (m_iR << 1);
	
		// middle
		Hex.x = xh - 1;
		Hex.y = yh;
		
		// left Edge
		if ( y < (m_iH - x * m) )
		{
			Hex.y--;
		} else
			// right Edge
			if ( y < (- m_iH + x * m) )
			{
				Hex.y--;
				Hex.x++;
			}
	}
	else 
	{
		x = (p.x + pos.x) % (m_iR << 1);
		xh = (p.x + pos.x) / (m_iR << 1);
		
		// middle
		Hex.x = xh;
		Hex.y = yh;
		
		// left Edge
		if ( y < (m_iH - x * m) )
		{
			Hex.x--;
			Hex.y--;
		} else
			// right Edge
			if ( y < (- m_iH + x * m) )
			{
				Hex.y--;
			}
	}
	
    return Hex;
}

Point HexGridCtrl::Hex2Screen(const Point& p)
{
	int xh = p.x * 2 * m_iR + ( p.y & 1) * m_iR;
	int yh = p.y * ( m_iH + m_iS );
	return Point(xh, yh);
}

void HexGridCtrl::LeftDown(Point p, dword flags)
{
	Point hex = Screen2Hex(p);
	
	if (hex.x >=0 && hex.x < m_iCols && hex.y >=0 && hex.y < m_iRows)
		OnLeftDown(hex, flags);
}

void HexGridCtrl::RightDown(Point p, dword flags)
{
	Point hex = Screen2Hex(p);
	
	if (hex.x >=0 && hex.x < m_iCols && hex.y >=0 && hex.y < m_iRows)
		OnRightDown( hex, flags);
}

