#include "NStateButton.h"


const NStateButton::Style *GetButtonStyle ( const Ctrl *q )
{
    const NStateButton::Style *st = &NStateButton::StyleNormal();

    if ( q->InFrame() )
    {
        st = &NStateButton::StyleEdge();

        if ( q->GetParent() )
        {
            Rect r = q->GetRect();
            Size sz = q->GetParent()->GetRect().GetSize();

            if ( r.right < sz.cx / 2 )
                st = &NStateButton::StyleLeftEdge();
        }
    }

    return st;
}

CH_STYLE ( NStateButton, Style, StyleNormal )
{
    CtrlsImageLook ( look, CtrlsImg::I_B );
    monocolor[0] = monocolor[1] = monocolor[2] = monocolor[3] =
                       Blend ( Blend ( SColorHighlight, SColorShadow ), SColorLabel, 80 );
    textcolor[0] = textcolor[1] = textcolor[2] = SColorLabel();
    textcolor[3] = SColorDisabled();
    font = StdFont();
    pressoffset = Point ( 0, 0 );
    focusmargin = 3;
    overpaint = 0;
    transparent = true;
}

CH_STYLE ( NStateButton, Style, StyleOk )
{
    Assign ( NStateButton::StyleNormal() );
    CtrlsImageLook ( look, CtrlsImg::I_OkB );
}

CH_STYLE ( NStateButton, Style, StyleEdge )
{
    Assign ( NStateButton::StyleNormal() );
    CtrlsImageLook ( look, CtrlsImg::I_EB );
}

CH_STYLE ( NStateButton, Style, StyleLeftEdge )
{
    Assign ( NStateButton::StyleEdge() );
}

CH_STYLE ( NStateButton, Style, StyleScroll )
{
    Assign ( NStateButton::StyleNormal() );
    CtrlsImageLook ( look, CtrlsImg::I_SB );
}



NStateButton::NStateButton()
{
    showimg = showlabel = push = false;
    index = 0;
    style = NULL;
    Transparent();
}


void NStateButton::Serialize ( Stream& s )
{
    int version = 0;
    s / version;
    int b = Get();
    s % b;
    Set ( b );

    if ( s.IsLoading() )
        Refresh();
}

void  NStateButton::Paint ( Draw& w )
{
    
    Size sz = GetSize();
    /**
    if(index < image.GetCount())
    	Size isz = image[index].GetSize();
    	*/
    Rect r = sz;

    int i = GetVisualState();

    //i = 0;
    //if(option) i = CTRL_PRESSED;
    ChPaint ( w, sz, style ? style->look[i] : GetButtonStyle ( this )->look[i] );

	if (showimg)
	{
	    Point p = r.CenterPos(image[index].GetSize());
	    w.DrawImage(p.x, p.y, DisabledImage((!IsNull(image[index])) ? image[index] : 0, !IsEnabled()));
	}

    if ( showlabel )
    {
        const Style *st = St();
        bool ds = !IsShowEnabled();
		DrawLabel dl;
        dl.text = label[index];
        dl.font = Nvl ( font, st->font );
//        dl.limg = img;
        dl.disabled = ds;
//        dl.lspc = !label.IsEmpty() && !img.IsEmpty() ? 4 : 0;
		dl.lspc = !label.IsEmpty() ? 4 : 0;
		
        if ( VisibleAccessKeys() )
            dl.accesskey = accesskey;

        if ( monoimg )
            dl.lcolor = SColorText;

        int i = GetVisualState();

		if(!showimg)
        	ChPaint ( w, sz, st->look[i] );

        dl.ink = st->textcolor[i];

        if ( monoimg )
            dl.lcolor = st->monocolor[i];

        dl.Paint ( w, 3 + push * st->pressoffset.x, 3 + push * st->pressoffset.y,
                   sz.cx - 6, sz.cy - 6 );
    }



    /**
    if(0 < image.GetCount())
        Point p = r.CenterPos(image[index].GetSize());
        */
    //w.DrawImage(p.x, p.y, DisabledImage((option && !IsNull(image[option])) ? image[option] : image[option], !IsEnabled()));
    //w.DrawImage(p.x, p.y, DisabledImage((option && !IsNull(image1)) ? image1 : image, !IsEnabled()));
}

int NStateButton::GetVisualState() const
{
	return !IsShowEnabled() ? CTRL_DISABLED :
	       push ? CTRL_PRESSED :
	       HasMouse() ? CTRL_HOT :
	       CTRL_NORMAL;
}

const NStateButton::Style *NStateButton::St() const
{
	const Style *st;
	if(style)
		st = style;
	else {
		st = GetButtonStyle(this);
		if(HasFocus())
			st = &StyleOk();
	}
	return st;
}

void  NStateButton::LeftDown ( Point, dword )
{
    push = true;
    Refresh();
}

void  NStateButton::LeftUp ( Point, dword )
{
    //option = !option;
    int maxindex = 0;

	maxindex = LimIndex();

    if ( 0 < maxindex )
    {
        index = modulo ( index + 1, maxindex );
    }

    else
        index = 0;

    push = false;

    UpdateActionRefresh();
}

void  NStateButton::MouseMove ( Point, dword flags )
{
    bool p = !! ( flags & K_MOUSELEFT );

    if ( push != p )
    {
        push = p;
        Refresh();
    }
}

void  NStateButton::MouseEnter ( Point, dword )
{
    Refresh();
}

void  NStateButton::MouseLeave()
{
    if ( push )
        push = false;

    Refresh();
}

void  NStateButton::SetData ( const Value& v )
{
    Set ( IsNull ( v ) ? 0 : IsString ( v ) ? String ( v ) == "1" : ( int ) v );
}

Value NStateButton::GetData() const
{
    return Get();
}

// --------------------
