#ifndef _NStateButton_NStateButton_h
#define _NStateButton_NStateButton_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;


class NStateButton : public Ctrl
{

    public:
        virtual void  Paint ( Draw& w );
        virtual void  LeftDown ( Point, dword );
        virtual void  LeftUp ( Point, dword );
        virtual void  MouseMove ( Point, dword );
        virtual void  MouseEnter ( Point, dword );
        virtual void  MouseLeave();
        virtual void  SetData ( const Value& v );
        virtual Value GetData() const;
        virtual void  Serialize ( Stream& s );

    public:

    struct Style : ChStyle<Style>
        {
            Value look[4];
            Color monocolor[4], textcolor[4];
            Point pressoffset;
            int   focusmargin;
            int   overpaint;
            Font  font;
            Image ok, cancel, exit;
            bool  transparent;
        };


    private:
        Array<Image> 	image;
        Array<String> 	label;
        const Style *	style;
        bool         	showimg;
        bool         	showlabel;
        bool        	push;
        int				index;
        byte    		accesskey;
        Font    		font;
        bool    		monoimg;

    private:
        int LimIndex()
        {
            if ( showimg && showlabel )
            {
                return min ( image.GetCount(), label.GetCount() );
            }

            else
            {
                if ( !showimg )
                {
                    return label.GetCount();
                }

                if ( !showlabel )
                {
                    return image.GetCount();
                }
            }
        }

    public:

        NStateButton&  AddImage ( const Image& img )
        {
            image.Add ( img );

            if ( 0 < image.GetCount() )
                showimg = true;

            Refresh();

            return *this;
        }

        void RemoveImage ( int i = 0, int n = 1 )
        {
            if ( i >= 0 && i < image.GetCount() )
            {
                image.Remove ( i, n );

                if ( index >= image.GetCount() )
                    ;

                index = image.GetCount() - 1;
            }

            if ( 0 < image.GetCount() )
                showimg = true;

            Refresh();
        }

        NStateButton&  AddLabel ( const String lab )
        {
            label.Add ( lab );
            Refresh();

            if ( 0 < label.GetCount() )
                showlabel = true;

            return *this;
        }

        void RemoveLabel ( int i = 0, int n = 1 )
        {
            if ( i >= 0 && i < label.GetCount() )
            {
                label.Remove ( i, n );

                if ( index >= label.GetCount() )
                    ;

                index = label.GetCount() - 1;
            }

            if ( 0 < label.GetCount() )
                showlabel = true;

            Refresh();
        }

        NStateButton& AddPair ( const Image & img, const String lab )
        {
            AddImage ( img );
            AddLabel ( lab );
        }

        void RemovePair ( int i = 0, int n = 1 )
        {
            RemoveImage ( i, n );
            RemoveLabel ( i, n );
        }

        void EnableImage ( bool b = true )
        {
            if ( 0 < image.GetCount() )
            {
                index = 0;
                showimg = b;
            }

            else
            {
                showimg = false;
            }

            Refresh();
        }

        void EnableLabel ( bool b = true )
        {
            if ( 0 < label.GetCount() )
            {
                index = 0;
                showlabel = b;
            }

            else
            {
                showlabel = false;
            }

            Refresh();
        }

        void operator= ( const Image& img )
        {
            AddImage ( img );
        }

        void operator= ( const String lab )
        {
            AddLabel ( lab );
        }

        void Set ( int b )
        {
            //ASSERT(b>=0 && b < image.GetCount());
            index = b;
            UpdateRefresh();
        }

        int Get() const
        {
            return index;
        }

        void operator= ( int b )
        {
            Set ( b );
        }


        NStateButton& SetStyle ( const Style& s )
        {
            style = &s;
            Refresh();
            return *this;
        }

        NStateButton& AutoStyle()
        {
            style = NULL;
            Refresh();
            return *this;
        }

        int      GetVisualState() const;
        const Style *St() const;

        static const Style& StyleNormal();
        static const Style& StyleOk();
        static const Style& StyleEdge();
        static const Style& StyleLeftEdge();
        static const Style& StyleScroll();

        NStateButton&  NormalStyle()
        {
            return SetStyle ( StyleNormal() );
        }

        NStateButton&  EdgeStyle()
        {
            return SetStyle ( StyleEdge() );
        }

        NStateButton&  LeftEdgeStyle()
        {
            return SetStyle ( StyleLeftEdge() );
        }

        NStateButton&  ScrollStyle()
        {
            return SetStyle ( StyleScroll() );
        }

        NStateButton();
};




class ViewNStateButton : public TopWindow
{

    public:
        typedef ViewNStateButton CLASSNAME;
        ViewNStateButton();

        void Click();

    private:
        NStateButton 	_button;
        NStateButton 	_button2;
        NStateButton 	_button3;
        Label			_label;
};

#endif

