#include "Topic2Html.h"

#define TOPICFILE <Topic2Html/app.tpp/all.i>
#include <Core/topic_group.h>

FileSel& HtmlFs()
{
	static FileSel fs;
	return fs;
}

VectorMap<String, String> links;
VectorMap<String, String> labels;  // not used

Topic2Html::Topic2Html()
{
	CtrlLayout(*this, "Topic to Html");
	Sizeable(true);
	AddFrame(menu);
	AddFrame(status);
	menu.Set(THISBACK(MainMenu));
	btnDir <<= THISBACK(SelDir);
	btnGo  <<= THISBACK(AllTopics2Html);
}


void Topic2Html::MainMenu(Bar& bar)
{
	menu.Add("File", THISBACK(FileMenu));
	menu.Add("Help", THISBACK(HelpMenu));
}

void Topic2Html::FileMenu(Bar& bar)
{
	bar.Add("Quit", THISBACK(Close));
}
void Topic2Html::HelpMenu(Bar& bar)
{
//	bar.Add("About..", THISBACK(About));
}

void Topic2Html::SelDir() {
	FileSel& fs = HtmlFs();
	fs.ExecuteSelectDir("Select Html-Directory");
	esDir.SetText(~fs);
};

void Topic2Html::OneTopic2Html(const String& group, const String& topic, const String& path, const String& name) {
	Index<String> css;
	String csss = "";
	Topic t = GetTopic("Topic2Html", group, topic);
	RichText rtext = ParseQTF(t.text, false, 0);
	String htm = EncodeHtml(rtext, css, links, labels, path,name);
	// EncodeHtml returns rtext with <P CLASS=A> tags
	// so this sets the tags for <STYLE TYPE="text/css">
	int ch = (int)'A';
	for (int i=0; i<css.GetCount();i++)
	{
		csss = csss + "." + (char)ch + "{" + css[i] + "}"; 
		ch++;
	}
	htm = HtmlHeader("Topic2Html " + name, csss, "") + htm;	
	htm << HtmlFooter();
	SaveFile(path + "/" + name + ".html",htm);
};

void Topic2Html::AllTopics2Html()
{
	String p = ~esDir;	//path to directory
	// translate all necessary links 
	links.Add("topic://Topic2Html/app/start$de-de","start.html");
	links.Add("topic://Topic2Html/app/page2$de-de","page2.html");
	
	OneTopic2Html("app","start$de-de", p , "start");
 	OneTopic2Html("app","page2$de-de", p , "page2");
};

// Copied from the file <web/html.cpp>
String Topic2Html::HtmlHeader(const char *title, String css, const char *other)
{
	String h =
		"<HTML>\r\n"
	    "<HEAD>\t\n"
	    "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\">\t\n"
	    "<META NAME=\"Generator\" CONTENT=\"U++ HTML Package\">\t\n"
	    "<TITLE>" + String(title) + "</TITLE>\r\n"
	;
	if(!IsNull(css))
		h << "<STYLE TYPE=\"text/css\"><!--\r\n"
		  << css << "\r\n-->\r\n</STYLE>\r\n";
	if(other)
		h << other;
	h << "</HEAD>\n";
	h << "<BODY>\n";
	return h;
}

String Topic2Html::HtmlFooter()
{
	String h =
		"</BODY>\n"
		"</HTML>\n"
	;
	return h;
}


GUI_APP_MAIN
{

	Topic2Html().Run();
}

