#include "CubeGL.h"

CubeGL::CubeGL()
{
	OldPt.Clear();
	Spin.Clear();
	Moving = false;
}

void CubeGL::LeftDown(Point p, dword keyflags)
{
	OldPt = p;
	SetCapture();
	Moving = true;
}

void CubeGL::MouseMove(Point p, dword )
{
	if( Moving )
	{
		Spin -= OldPt - p;
		OldPt = p;
		PostPaintGL();
	}
}

void CubeGL::LeftUp(Point p, dword keyflags)
{
	ReleaseCapture();
	SetFocus();
	Moving = false;
}

void CubeGL::InitGL()
{
	glClearColor( 1.0f, 1.0f, 1.0f, 1.0f );
	glEnable(GL_DEPTH_TEST);
	glShadeModel(GL_SMOOTH);
}

void CubeGL::DoneGL()
{
}

void CubeGL::ResizeGL( int w, int h )
{
	glViewport(0, 0, w, h);
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();
	gluPerspective( 45.0, (GLdouble)w / (GLdouble)h, 0.1, 100.0);
}

void CubeGL::PaintGL()
{	
	static Vertex Cube[] =
	{
	{1.0f, 0.0f, 0.7f, -1.0f,-1.0f, 1.0f },
	{0.0f, 0.8f, 0.2f,  1.0f,-1.0f, 1.0f },
	{0.4f, 0.6f, 0.7f,  1.0f, 1.0f, 1.0f },
	{0.3f, 0.3f, 0.9f, -1.0f, 1.0f, 1.0f },

	{1.0f, 0.0f, 0.7f, -1.0f,-1.0f,-1.0f },
	{0.3f, 0.3f, 0.9f, -1.0f, 1.0f,-1.0f },
	{0.4f, 0.6f, 0.7f,  1.0f, 1.0f,-1.0f },
	{0.0f, 0.8f, 0.2f,  1.0f,-1.0f,-1.0f },

	{1.0f, 0.0f, 0.7f, -1.0f, 1.0f,-1.0f },
	{0.3f, 0.3f, 0.9f, -1.0f, 1.0f, 1.0f },
	{0.4f, 0.6f, 0.7f,  1.0f, 1.0f, 1.0f },
	{0.0f, 1.0f, 0.0f,  1.0f, 1.0f,-1.0f },

	{1.0f, 0.0f, 0.5f, -1.0f,-1.0f,-1.0f },
	{0.4f, 0.6f, 0.7f,  1.0f,-1.0f,-1.0f },
	{0.0f, 0.0f, 1.0f,  1.0f,-1.0f, 1.0f },
	{0.2f, 0.3f, 0.7f, -1.0f,-1.0f, 1.0f },

	{0.4f, 0.6f, 0.7f, 1.0f,-1.0f,-1.0f },
	{0.0f, 0.0f, 1.0f, 1.0f, 1.0f,-1.0f },
	{0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f },
	{0.0f, 0.8f, 0.2f, 1.0f,-1.0f, 1.0f },

	{1.0f, 1.0f, 1.0f, -1.0f,-1.0f,-1.0f },
	{0.0f, 0.8f, 0.2f, -1.0f,-1.0f, 1.0f },
	{0.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f },
	{0.0f, 1.0f, 0.0f, -1.0f, 1.0f,-1.0f }
	};
	
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();
	glTranslatef( 0.0f, 0.0f, -5.0f );
	glRotatef( Spin.y/3.0, 1.0f, 0.0f, 0.0f );
	glRotatef( Spin.x/3.0, 0.0f, 1.0f, 0.0f );

	glInterleavedArrays( GL_C3F_V3F, 0, Cube );
	glDrawArrays( GL_QUADS, 0, 24 );
}
