#ifndef _OPENGLCTRL_H_
#define _OPENGLCTRL_H_

#include <CtrlLib/CtrlLib.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>

class OpenGLCtrl : public Ctrl
{
	GLXContext SubWindowContext;
	Window     SubWindow;
	bool       IsInitialized,
	           IsMapped;
	int        DepthSize,
	           StencilSize;
	bool       DoubleBuffering;

	int        NumInstance;
	static int NbInstance;
	static int ContextActivated;
	void ActivateContext();
	
	Point CurrentPos;
	
	Rect RectInTopWindow() const;
	void MapWindow();
	void UnMapWindow();
	bool CreateGLXWindow( Window &, GLXContext & );
	void EventProc(XWindow& w, XEvent *event);
	void Paint(Draw& draw);
	
	void MoveSubWindow();
	void OpenGLPaint();
	void OpenGLResize();

public:
	typedef OpenGLCtrl CLASSNAME;

	OpenGLCtrl( int depthsize = 24, int stencilsize = 0, bool doublebuffer = true );
	~OpenGLCtrl();

	void OpenGL();
	void CloseGL();

	void PostResizeGL();
	void PostPaintGL();

	// User methods
	virtual void InitGL();
	virtual void DoneGL();	
	virtual void ResizeGL( int w, int h );
	virtual void PaintGL();
	virtual void State(int reason);
};

#endif
