#ifndef _CMAinDlg_h
#define _CMAinDlg_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <ComboColors/MainDlg.lay>
#include <CtrlCore/lay.h>

struct ComboColorsDisplay : Display 
{
	Color foreColor;
	Color bkColor;
	Font font;

	void Paint(Draw& w, const Rect& r, const Value& q,Color ink, Color paper, dword s) const 
	{
		w.DrawRect(r, bkColor);
		
		String vt = q;
		const char *txt = GetENUS(vt);
		int x = r.left;
		w.DrawText(x, r.top, AsCString(txt), font, foreColor);
	}
	
	ComboColorsDisplay(Color fore, Color bk) : foreColor(fore),bkColor(bk) {}
};

class CMainDlg : public WithMainDlgLayout<TopWindow> 
{
public:
	typedef CMainDlg CLASSNAME;
	CMainDlg();
		
private:
	void OnButtonChangeColor(void);

};

#endif

