/* by aris002@yahoo.co.uk
* this is a test example for agg and upp integration
* it uses nImage (without the main.cpp inside :)).
* Install like normal upp package
* Any questions - http://www.arilect.com/upp/forum/
*/
//#define AGG_RGB24
//#define AGG_BGRA32 
//#define AGG_RGBA32 
//#define AGG_ARGB32 
//#define AGG_ABGR32
//#define AGG_RGB565
//#define AGG_RGB555
//#define AGG_GRAY8
//#define AGG_BGR24

#define AGG_RGBA32
#include <agg_aris_main/agg_aris_main.h>

agg::path_storage aggTriangle(double *_m_x, double *_m_y)
{
	//aris: FIXME ...
	agg::path_storage path;
		path.move_to(_m_x[0], _m_y[0]);
		path.line_to(_m_x[1], _m_y[1]);
		path.line_to(_m_x[2], _m_y[2]);
	path.close_polygon();
	return path;
};


#include <nImage/Image.h>
#include <nImage/Raster.h>

// AGG rendering buffer class - pointers to each row.


//=====================================
class App : public TopWindow {
private:

//not very important for agg-upp - just a as database...
	agg::path_storage m_path1;
	agg::path_storage m_path2;  //make an array?
	
	double m_x[3];
	double m_y[3];
	double m_dx;
	double m_dy;
	int    m_idx;
	
	double m_gamma_value;
	double m_alpha_value;

//upp Ctrls...
	SliderCtrl gamma_slider;
	SliderCtrl alpha_slider;
	SliderCtrl movement_slider;
	Option option;  //for switching buffers - not used in here
public:
	virtual void Paint(Draw& draw);
	typedef App CLASSNAME;

//they were local in the original examples, what if to make them private or maybe global...
	typedef agg::renderer_base<pixfmt> renderer_base;
	typedef agg::renderer_scanline_aa_solid<renderer_base> renderer_aa;  //anti-aliased
	typedef agg::renderer_scanline_bin_solid<renderer_base> renderer_bin; //normal

	agg::rasterizer_scanline_aa<> ras1;  //rasterizers- deal with paths and accuracy
	agg::rasterizer_scanline_aa<> ras2;

	pixfmt                 pixf;  //can we call it pixel formatter?...
	renderer_base          ren_base;
	renderer_aa            ren_aa;     //aa - anti-aliased
	renderer_bin           ren_bin;  //deal with colors - bin - low quality 

	agg::scanline_p8              m_sl_p8;  // 1/3 pix accuracy?
	agg::scanline_bin             m_sl_bin; // normal non-aliased

//focus your agg learning there ... :)
	void App::SetRenderersAlpha();
	void App::SetRasterizersGamma();
	void App::SetMoveTriangles();

	Image aggImg(int cx, int cy);  //main thing...
	App();
};


void App::Paint(Draw& w)
{
	Size sz = GetSize();
	w.DrawRect(GetSize(), SLtGray);
	
//	ras.add_path(aggTriangle(m_x, m_y));  //if you want to use dynamic and dependant on upp Ctrls...
	aggImg(600,400).Paint(w, 50, 50);
}


void App::SetRasterizersGamma()
{
	m_gamma_value=(double)~gamma_slider/100;
	
	ras1.gamma(agg::gamma_power( m_gamma_value*2.0)); 
	ras2.gamma(agg::gamma_threshold(m_gamma_value));

	Refresh();
}

void App::SetRenderersAlpha()
{
	m_alpha_value=1.0-(double)~alpha_slider/100;
	
	ren_aa.color(agg::rgba(0.7, 0.5, 0.1, m_alpha_value)); //it's enough to init the renderer only once unless you want dynamic...
	ren_bin.color(agg::rgba(0.1, 0.5, 0.7, m_alpha_value)); //gives possibility for styles!...

	Refresh();  
}

void App::SetMoveTriangles()
{
	int delta = ~movement_slider;

		m_x[0] = 100 + 80+delta; m_y[0] = 60-delta;
		m_x[1] = 369 + 80-delta; m_y[1] = 170-delta;
		m_x[2] = 143 + 80; m_y[2] = 310;
	m_path1=aggTriangle(m_x, m_y);

		m_x[0] = 100 + 120+delta; m_y[0] = 60+50-delta;
		m_x[1] = 369 + 120-delta; m_y[1] = 170+50-delta;
		m_x[2] = 143 + 120; m_y[2] = 310+50;
	m_path2=aggTriangle(m_x, m_y);
	
	ras1.add_path(m_path1); //must set ras' - add path (or other things) every time before Paint()?
	ras2.add_path(m_path2);
	
	Refresh();
}


Image App::aggImg(int cx, int cy)
{
	ImageBuffer uibuf(cx,cy);  //might better to have not the ImageBuffer but DIBSection pixels?..
	memset(uibuf, 255, cx * cy * 4); //!!!change or remove this for the background...
		agg::rendering_buffer rbuf;
	rbuf.attach((agg::int8u *)uibuf[0], cx, cy, cx*4); //THIS IS THE MAIN agg and upp CONNECTION!!!
	//attachments can be combined from params?..
	                              pixf.attach(rbuf);
	              ren_base.attach(pixf);
	ren_aa.attach(ren_base);
	ren_bin.attach(ren_base);

	agg::render_scanlines(ras2, m_sl_bin, ren_bin); //actual rendering!!! must think about...
	agg::render_scanlines(ras1, m_sl_p8, ren_aa);  //... front-back order

	return uibuf;
}



App::App()
{
//not important for agg...
	alpha_slider.SetRect(400,200,20,100);
	Add(alpha_slider);
	alpha_slider.MinMax(0,100);
	alpha_slider.SetData(30);

	gamma_slider.SetRect(430,200,20,100);
	Add(gamma_slider);
	gamma_slider.MinMax(0,100);
	gamma_slider.SetData(90);

	movement_slider.SetRect(350,350,100,20);
	Add(movement_slider);
	movement_slider.MinMax(0,100);
	movement_slider.SetData(25);

	option.SetRect(400, 420, 15, 15); //not used
	Add(option);

	alpha_slider.WhenAction=THISBACK(SetRenderersAlpha);  //colors
	gamma_slider.WhenAction=THISBACK(SetRasterizersGamma); //quality
	movement_slider.WhenAction=THISBACK(SetMoveTriangles);  //position

	BackPaint();
//important for agg!...
	SetRenderersAlpha();  //must assign colors to renderers!!!
	SetRasterizersGamma();
	SetMoveTriangles();  //add polygons paths to rasterizers instead like below...

//	ras1.add_path(m_path1); //add path (or other things) to rasterizers after BackPaint()... or inside Paint()
//	ras2.add_path(m_path2); //add path (or other things) to rasterizers after BackPaint()... or inside Paint()

}


GUI_APP_MAIN
{
	App().Title("agg_aris_upp_rasterizers_1").Run();
}
