//////////////////////////////////////////////////////////////////
// ActionMouseAdapter: mouse adapter supporting simple drag & drop.

#include <utility/misc.jinc>

package utility;

import java.awt.*;
import java.awt.event.*;

public class ActionAdapter
{
	public ActionAdapter(Component component)
	{
		repeat = new DelayedThread()
		{
			public void timer()
			{
				if(pushed)
				{
					doRepeat();
					repeat.set(rep_speed);
				}
			}
		};
		this.component = component;
		component.addMouseListener(new MouseAdapter()
		{
			public void mousePressed (MouseEvent e)       { NOLOG("mousePressed");  if(ActionAdapter.this.component.isEnabled()) { pos = e.getPoint(); push(); } }
			public void mouseReleased(MouseEvent e)       { NOLOG("mouseReleased"); if(ActionAdapter.this.component.isEnabled()) release(); }
			public void mouseExited  (MouseEvent e)       { NOLOG("mouseExited");   entered = false; cancel(); }
			public void mouseEntered (MouseEvent e)       { NOLOG("mouseEntered");  if((e.getModifiers() & e.BUTTON1_MASK) == 0) entered = true; doRefresh(); }
		});

		component.addKeyListener(new KeyAdapter()
		{
			public void keyPressed (KeyEvent e)           { if(ActionAdapter.this.component.isEnabled() && e.getKeyCode() == KeyEvent.VK_SPACE) push(); }
			public void keyReleased(KeyEvent e)           { if(pushed) release(); }
		});
	}

	public boolean           isPushAction()               { return pushAction; }
	public synchronized void setPushAction(boolean _pact) { pushAction = _pact; }

	public Point             getPosition()                   { return pos; }

	public int               getRepeatDelay()                { return rep_delay; }
	public int               getRepeatSpeed()                { return rep_speed; }
	public synchronized void setRepeat(int delay, int speed) { rep_delay = delay; rep_speed = speed; }
	public synchronized void setRepeat()                     { rep_delay = 300; rep_speed = 50; }
	public synchronized void setNoRepeat()                   { rep_delay = 0; }

	public void push()
	{
//		LOG("push");
		synchronized(this)
		{
			repeat.remove();
			pushed = true;
		}
//		LOG("/sync, pushed = " + pushed);
		doPush();
//		LOG("/doPush, pushed = " + pushed);
		doRefresh();
		if(rep_delay > 0)
			repeat.set(rep_delay);
//		LOG("/push, pushed = " + pushed);
	}

	public void release()
	{
//		LOG("release, pushed = " + pushed);
		synchronized(this)
		{
			repeat.remove();
			if(!isPushed())
				return;
			pushed = false;
		}
		doRelease();
		doRefresh();
//		LOG("/release");
	}

	public void cancel()
	{
		boolean cc;
		synchronized(this)
		{
			repeat.remove();
			cc = pushed;
			pushed = false;
		}
		if(cc)
			doCancel();
		doRefresh();
	}

	protected void doPush()    { if(pushAction) { doAction(); } }
	protected void doRepeat()  { entered = false; doAction(); }
	protected void doCancel()  {}
	protected void doRelease() { if(!pushAction) { doAction(); } }
	protected void doRefresh() {}
	protected void doAction()  {}

	public boolean isPushed()  { return pushed; }
	public boolean isEntered() { return entered; }

	private Point     pos = new Point(0, 0);
	private boolean   pushed = false;
	private boolean   pushAction = false;
	private boolean   entered = false;
	private Component component;
	private int       rep_delay = 0; // autorepeat delay in ms, 0 = no autorepeat
	private int       rep_speed = 0; // autorepeat speed in ms
	private DelayedThread repeat;
}
