//////////////////////////////////////////////////////////////////////
// ColorCtrl: color editor component.

#define LLOG(x) // RLOG(x)

#ifndef flagNODLGCOLOR

#include <utility/misc.jinc>

package utility;

import java.awt.*;
import java.awt.event.*;

public class ColorCtrl extends Component
{
	public ColorCtrl(boolean not_null, String title)
	{
		LLOG("ColorCtrl ctr");
		this.editable = true;
		this.not_null = not_null;
		this.title = title;
		adapter = new ActionAdapter(this)
		{
			protected void doRefresh() { repaint(); }
			protected void doAction()  { if(isEnabled() && editable) doSelect(); }
		};
	}

	public ColorCtrl(boolean nn)
	{ this(nn, null); }
	public ColorCtrl()
	{ this(true, null); }

//	public void doLayout() { super.doLayout(); LLOG("ColorCtrl.doLayout"); }
//	public void update(Graphics g) { super.update(); LLOG("ColorCtrl.update"); paint(g); }

	public void paint(Graphics g)
	{
		super.paint(g);
		Dimension size = getSize();
		LLOG("ColorCtrl.paint, size = " + size);
		int wd = size.width, ht = size.height;
		GUtil.drawRect(g, 0, 0, wd, ht, 1, Color.gray, Color.white);
		GUtil.drawRect(g, 1, 1, wd - 2, ht - 2, 1, Color.black, SystemColor.control);
		GUtil.fillRect(g, 2, 2, wd - 4, ht - 4, isEnabled() ? Color.white : SystemColor.control);
		int x = 0, y = 0;
		if(editable && adapter.isPushed())
		{
			x++;
			y++;
		}
		if(color == null)
		{
			String s = t_("(no color)");
			FontMetrics fm = g.getFontMetrics();
//			LOG("ascent  = " + fm.getAscent());
//			LOG("descent = " + fm.getDescent());
//			LOG("height  = " + fm.getHeight());
//			LOG("leading = " + fm.getLeading());
			int tw = fm.stringWidth(s);
			g.setColor(Color.black);
			g.drawString(s, ((size.width - tw) >> 1) + x, ((size.height + fm.getHeight()) >> 1) + y - fm.getDescent());
		}
		else
		{
			GUtil.drawRect(g, x + 5, y + 5, wd - 10, ht - 10, 1, SystemColor.control, Color.gray);
			GUtil.fillRect(g, x + 6, y + 6, wd - 12, ht - 12, color);
		}
	}

	public void    setEditable(boolean ed) { editable = ed; }
	public boolean isEditable()            { return editable; }

	public void    setColor(Color c) { color = c; repaint(); }
	public Color   getColor()        { return color; }

	public Color   pump(Color c, boolean write)
	{
		if(write)
			return getColor();
		else
		{
			setColor(c);
			return color;
		}
	}

	public void    doSelect()
	{
		DlgColor dlg = new DlgColor(this, ColorCtrl.this.not_null, ColorCtrl.this.title);
		dlg.setColor(color);
		if(dlg.run() != 0)
		{
			color = dlg.getColor();
//			LOG("color = " + color);
			repaint();
		}
	}

	private ActionAdapter adapter;
	private Color color = Color.red;
	private boolean not_null;
	private boolean editable;
	private String  title;
}

#else

public class ColorCtrl
{
	LLOG("Dummy ColorCtrl");
}

#endif//flagNODLGCOLOR
