//////////////////////////////////////////////////////////////////
// DragDropTarget: action target for drag & drop mouse adapter.

#include <utility/misc.jinc>

package utility;

import java.awt.*;

public class DragDropTarget
{
	protected void    doMove(Point pt)                           {}
	protected boolean doPush(Point pt)                           { return true; }
	protected void    doDrag(Point begin, Point last, Point next)
	{
		Rectangle a = (last == null ? null : Util.sortRect(begin, last));
		Rectangle b = (next == null ? null : Util.sortRect(begin, next));
		if(a == null && b == null
		|| a != null && b != null && a.equals(b))
			return;
		doDragRect(a, b);
	}
	protected void    doDragRect(Rectangle last, Rectangle next) {}
	protected void    doClick(Point pt)                          {}
	protected void    doClickRight(Point pt)                     {}
	protected void    doDrop(Point begin, Point end)             { doDropRect(Util.sortRect(begin, end)); }
	protected void    doDropRect(Rectangle rc)                   {}
	protected Point   doDropRight(Point begin, Point end)        { return begin; }
	protected void    doCancel()                                 {}
	protected Cursor  getCursor(Point pt)                        { return null; }

	protected boolean isShift = false, isCtrl = false, isDown = false;
};
