///////////////////////////////////////////////////////////////////
// DropList: map-oriented combo box.

#include <utility/misc.jinc>

package utility;

import java.awt.*;
import java.util.*;

public class DropList extends Choice
{
	public DropList() { clear(); }

	public synchronized void clear()
	{
		super.removeAll();
		keys = new Vector();
	}

	public synchronized void add(Object key, String text)
	{
		this.keys.addElement(key);
		super.add(text);
	}

	public synchronized void add(double key, String text) { add(new Double(key), text); }
	public synchronized void add(String s)                { add(s, s); }
	public synchronized void add(double d)                { add(d, String.valueOf(d)); }

	public void setData(Object o)
	{
		for(int i = 0, n = keys.size(); i < n; i++)
			if(keys.elementAt(i).equals(o))
			{
				select(i);
				break;
			}
	}

	public Object getData()
	{
		int i = getSelectedIndex();
		if(i >= 0 && i < keys.size())
			return keys.elementAt(i);
		return null;
	}

	public double getDouble()
	{
		Object o = getData();
		if(o instanceof Number)
			return ((Number)o).doubleValue();
		return Util.DBL_NULL;
	}

	public Object pump(Object o, boolean write)
	{
		if(!write)
			setData(o);
		else
			o = getData();
		return o;
	}

	public double pump(double d, boolean write)
	{
		Object o = pump(new Double(d), write);
		if(o != null && o instanceof Number)
			return ((Number)o).doubleValue();
		return Util.DBL_NULL;
	}

	public int pump(int d, boolean write)
	{
		Object o = pump(new Double(d), write);
		if(o != null && o instanceof Number)
			return ((Number)o).intValue();
		return Util.INT_NULL;
	}

	public String pump(String s, boolean write)
	{
		Object o = pump(s, write);
		if(o != null && o instanceof String)
			return (String)o;
		return null;
	}

	private Vector keys;
};
