#include <utility/misc.jinc>

package utility;

import java.awt.*;
import java.awt.event.*;

public class LabelBox extends Component
{
	public LabelBox(String label)
	{
		this.label = label;
	}
	
	public void paint(Graphics g)
	{
		Rectangle rc = new Rectangle(getSize());
		Font font = getFont();
		int asc = 0, dsc = 0, ytxt = 0, tl = rc.x, tr = rc.x;
		if(label != null) {
			g.setFont(getFont());
			FontMetrics metrics = g.getFontMetrics();
			asc = metrics.getAscent();
			dsc = metrics.getDescent();
			int wd = metrics.charWidth('9');
			ytxt = rc.y + asc;
			int dy = (asc + dsc) >> 1;
			rc.y += dy;
			rc.height -= dy;
			tl = rc.x + wd;
			tr = tl + metrics.stringWidth(label) + 2 * XGAP;
		}
		g.setColor(Color.white);
		g.fillRect(rc.x + 1, rc.y, 1, rc.height);
		g.fillRect(rc.x + 1, rc.y + rc.height - 1, rc.width - 1, 1);
		g.fillRect(rc.x + rc.width - 1, rc.y + 1, 1, rc.height - 1);
		g.fillRect(rc.x + 1, rc.y + 1, tl - rc.x - 1, 1);
		g.fillRect(tr, rc.y + 1, rc.x + rc.width - tr, 1);
		g.setColor(Color.gray);
		g.fillRect(rc.x, rc.y, 1, rc.height - 1);
		g.fillRect(rc.x, rc.y + rc.height - 2, rc.width - 1, 1);
		g.fillRect(rc.x + rc.width - 2, rc.y, 1, rc.height - 1);
		g.fillRect(rc.x, rc.y, tl - rc.x, 1);
		g.fillRect(tr, rc.y, rc.x + rc.width - tr, 1);
		if(label != null) {
			g.setColor(getForeground());
			g.drawString(label, tl + XGAP, ytxt);
		}
	}

	private static final int XGAP = 3;
	private String label;
}
