#include <utility/misc.jinc>

package utility;

public class LangInfo {
	public String translate(String en)
	{
		if(en == null || en.length() == 0)
			return en;
		if(Util.langcode == Util.LANG_CS || Util.langcode == Util.LANG_DE) {
			Object o = map.get(en);
			String out = null;
			if(o != null) {
				LngRec lr = (LngRec)o;
				switch(Util.langcode) {
					case Util.LANG_CS: out = lr.cs; break;
					case Util.LANG_DE: out = lr.de; break;
				}
			}
			if(out == null || out.length() == 0) {
				out = en;
				int i;
				if((i = out.indexOf((char)7)) >= 0 || (i = out.indexOf((char)11)) >= 0)
					out = out.substring(i + 1);
			}
			return out;
		}
		return en;
	}

	public void en(String en)
	{
		map.put(en, last_rec = new LngRec());
	}

	public void cs(String cs)
	{
		last_rec.cs = cs;
	}

	public void de(String de)
	{
		last_rec.de = de;
	}

	private class LngRec {
		String cs, de;
	};

	private LngRec last_rec;
	private java.util.Hashtable map = new java.util.Hashtable();
}
