#include <utility/misc.jinc>

package utility;

import java.awt.*;

#define LLOG(x) // RLOG(x)

public class Pump
{
	public static class PumpException extends Exception
	{
		public PumpException(Component component, String text)
		{ this.component = component; this.text = text; }

		public PumpException(Component component)
		{ this(component, t_("Invalid value.")); }

		public void show()
		{
			Component c = component;
			while(!(c instanceof Window) && c.getParent() != null)
				c = c.getParent();
			new MessageBox(c, text).focus(component).run();
		}

		private Component component;
		private String    text;
	};

	public static class StringHolder
	{
		public StringHolder()          { s = ""; }
		public StringHolder(String s)  { this.s = s; }

		public String  get()           { return s; }
		public void    set(String s)   { this.s = s; }

		public boolean isEmpty()       { return s == null || s.length() == 0; }

		String s;
	};

	public Pump(boolean write)
	{
		this.write = write;
	}

	public int pump(int value, StringHolder s, Component c, boolean not_null, int l, int h) throws PumpException
	{
		if(write)
		{
			if(s.isEmpty())
			{
				if(not_null)
					throw new PumpException(c, t_("Empty value not allowed."));
				return Util.INT_NULL;
			}
			try
			{
				value = Integer.parseInt(s.get());
			}
			catch(NumberFormatException e)
			{
				throw new PumpException(c, t_("Invalid input (integer expected)."));
			}
			if(l != Util.INT_NULL && value < l || h != Util.INT_NULL && value > h)
			{
				String err;
				if(l == Util.INT_NULL)
					err = t_("Maximum allowed value (") + String.valueOf(h) + t_(") exceeded.");
				else if(h == Util.INT_NULL)
					err = t_("Minimum allowed value (") + String.valueOf(l) + t_(") exceeded.");
				else
					err = t_("Valid range: ") + String.valueOf(l) + t_(" to ") + String.valueOf(h) + t_(".");
				throw new PumpException(c, err);
			}
		}
		else
			s.set(value == Util.INT_NULL ? "" : String.valueOf(value));
		return value;
	}

	public int pump(int value, TextComponent tc, boolean not_null, int l, int h) throws PumpException
	{
		StringHolder s = new StringHolder();
		if(write)
			s.set(tc.getText());
		value = pump(value, s, tc, not_null, l, h);
		if(!write)
			tc.setText(s.get());
		return value;
	}

	public int pump(int value, TextComponent tc, boolean not_null) throws PumpException { return pump(value, tc, not_null, Util.INT_NULL, Util.INT_NULL); }
	public int pump(int value, TextComponent tc)                   throws PumpException { return pump(value, tc, true); }

	public double pump(double value, StringHolder s, Component c, boolean not_null, double l, double h) throws PumpException
	{
		return pump(value, s, c, not_null, l, h, 6);
	}

	public double pump(double value, StringHolder s, Component c, boolean not_null, double l, double h, int decimals) throws PumpException
	{
		if(write) {
			if(s.isEmpty()) {
				if(not_null)
					throw new PumpException(c, t_("Empty value not allowed."));
				return Util.DBL_NULL;
			}
			try {
				String snom = s.get(), sden = "1";
				int icol = snom.indexOf(':');
				if(icol >= 0) {
					sden = snom.substring(icol + 1, snom.length() - icol - 1);
					snom = snom.substring(0, icol);
				}
				LLOG("snom = " + snom + ", sden = " + sden);
				value = Double.valueOf(snom).doubleValue();
				double d = Double.valueOf(sden).doubleValue();
				if(value != Util.DBL_NULL && d != Util.DBL_NULL && d != 0.0)
					value /= d;
			}
			catch(NumberFormatException e) {
				throw new PumpException(c, t_("Invalid input (real number expected)."));
			}
			if(l != Util.DBL_NULL && value < l || h != Util.DBL_NULL && value > h) {
				LLOG("value = " + value);
				String err;
				if(l == Util.DBL_NULL)
					err = t_("Maximum allowed value (") + String.valueOf(h) + t_(") exceeded.");
				else if(h == Util.DBL_NULL)
					err = t_("Minimum allowed value (") + String.valueOf(l) + t_(") exceeded.");
				else
					err = t_("Valid range: ") + String.valueOf(l) + t_(" to ") + String.valueOf(h) + t_(".");
				throw new PumpException(c, err);
			}
		}
		else {
			s.set(value == Util.DBL_NULL ? "" : Util.asString(value, decimals, false));
		}
		return value;
	}

	public double pump(double value, TextComponent tc, boolean not_null, double l, double h) throws PumpException
	{
		return pump(value, tc, not_null, l, h, 6);
	}

	public double pump(double value, TextComponent tc, boolean not_null, double l, double h, int decimals) throws PumpException
	{
		StringHolder s = new StringHolder();
		if(write)
			s.set(tc.getText());
		value = pump(value, s, tc, not_null, l, h, decimals);
		if(!write)
			tc.setText(s.get());
		return value;
	}

	public String pump(String value, TextComponent tc, boolean not_null) throws PumpException
	{
		if(!write)
		{
			tc.setText(value);
			return value;
		}
		else
		{
			String s = tc.getText();
			if((s == null || s.length() == 0) && not_null)
				throw new PumpException(tc, t_("Empty value not allowed."));
			return s;
		}
	}

	public String pump(String value, TextComponent tc) throws PumpException
	{ return pump(value, tc, false); }

	public int pump(int value, Choice choice)
	{
		if(write)
			value = choice.getSelectedIndex();
		else
			choice.select(value);
		return value;
	}

	public int pump(int value, Choice choice, int table[])
	{
		if(write)
			value = table[choice.getSelectedIndex()];
		else
		{
			choice.removeAll();
			int x = 0;
			for(int i = 0; i < table.length; i++)
			{
				if(table[i] == value)
					x = i;
				choice.add(String.valueOf(table[i]));
			}
			choice.select(x);
		}
		return value;
	}

	public String pump(String value, Choice choice, String table[])
	{
		String s;
		if(write)
			s = table[choice.getSelectedIndex()];
		else
		{
			choice.removeAll();
			int x = 0;
			if(value != null)
				for(int i = 0; i < table.length; i++)
				{
					if(table[i].equals(value))
						x = i;
					choice.add(table[i]);
				}
			choice.select(x);
			s = value;
		}
		return s;
	}

	public boolean pump(boolean value, Checkbox check)
	{
		if(write)
			value = check.getState();
		else
			check.setState(value);
		return value;
	}

	public int pump(int value, Checkbox radio, int radio_value)
	{
		if(write)
		{
			if(radio.getState())
				value = radio_value;
		}
		else if(value == radio_value)
			radio.setState(true);
		return value;
	}

	public double pump(double value, TextComponent tc, boolean not_null)               throws PumpException { return pump(value, tc, not_null, Util.DBL_NULL, Util.DBL_NULL); }
	public double pump(double value, TextComponent tc, boolean not_null, int decimals) throws PumpException { return pump(value, tc, not_null, Util.DBL_NULL, Util.DBL_NULL, decimals); }
	public double pump(double value, TextComponent tc)                                 throws PumpException { return pump(value, tc, true); }
	public double pump(double value, TextComponent tc, int decimals)                   throws PumpException { return pump(value, tc, true, decimals); }

	private boolean write;
}
