package utility.formatting;

import java.awt.*;
import utility.*;

public class TextDisplayItem implements DisplayItem
{
	public TextDisplayItem(String text, Font font, Graphics ref_context)
	{
		setup(text, font, ref_context);
	}

	public TextDisplayItem(String text, Font font, Component ref_component)
	{
		Graphics g = ref_component.getGraphics();
		setup(text, font, g);
		g.dispose();
	}

	public TextDisplayItem(String text, Font font)
	{
		this(text, font, GUtil.applet);
	}

	public TextDisplayItem(String text)
	{
		this(text, GUtil.applet.getFont(), GUtil.applet);
	}

	public final void setWidth(int _width) { width = _width; }
	public final void setAscent(int _ascent) { ascent = _ascent; }
	public final void setDescent(int _descent) { descent = _descent; }
	public final void setLeading(int _leading) { leading = _leading; }

	private final void setup(String text, Font font, Graphics ref_context)
	{
		this.text = text;
		this.font = font;
		ref_context.setFont(font);
		FontMetrics metrics = ref_context.getFontMetrics();
		ascent = metrics.getAscent();
		descent = metrics.getDescent();
		leading = metrics.getLeading();
		width = metrics.stringWidth(this.text);
	}

	public final int  getAscent()   { return ascent; }
	public final int  getDescent()  { return descent; }
	public final int  getLeading()  { return leading; }
	public final int  getWidth()    { return width; }

	public final void paint(Graphics g, int left, int baseline)
	{
		g.setFont(font);
		g.drawString(text, left, baseline);
	}

	private Font font;
	private int  ascent, descent, leading, width;
	String       text;
}
