//////////////////////////////////////////////////////////////////////
// Animation: simple animation control.

package utility;

import java.awt.*;

public class Animation extends Canvas implements Runnable, Quittable
{
	//////////////////////////////////////////////////////////////////////

	public Animation(ImageMap map, int delta_t)
	{
		this.map = map;
		this.delta_t = delta_t;
		QuitMap.main.add(this);
	}

	//////////////////////////////////////////////////////////////////////

	public synchronized void start()
	{
		quit();
		stop_frame = -1;
		anim_thread = new Thread(this);
		anim_thread.setPriority(Thread.MAX_PRIORITY);
		anim_thread.start();
	}

	//////////////////////////////////////////////////////////////////////

	public boolean isRunning() { return anim_thread != null; }
	public int getFrame() { return frame; }
	public synchronized void setFrame(int frame) { this.frame = frame; repaint(); }

	//////////////////////////////////////////////////////////////////////

	public void stop(int frame)
	{
		stop_frame = frame;
	}

	//////////////////////////////////////////////////////////////////////

	public void quit()
	{
		anim_thread = null;
	}

	//////////////////////////////////////////////////////////////////////

	public void run()
	{
		int items = map.getWidth() / map.getItemSize().width;
		Thread thread;
		try
		{
			while((thread = anim_thread) != null && frame != stop_frame)
			{
				thread.sleep(delta_t);
				synchronized(this)
				{
					if((thread = anim_thread) == null)
						break;
					if(++frame >= items)
						frame = 0;
					Graphics g = getGraphics();
					paint(g);
					g.dispose();
				}
			}
		}
		catch(InterruptedException e)
		{
		}
	}

	//////////////////////////////////////////////////////////////////////

	public Dimension getPreferredSize() { return map.getItemSize(); }
	public Dimension getMinimumSize() { return map.getItemSize(); }

	//////////////////////////////////////////////////////////////////////

	public void paint(Graphics g)
	{
		Dimension dim = getSize(), frm = map.getItemSize();
		map.drawImage(g, frame,
			new Point((dim.width - frm.width) >> 1, (dim.height - frm.height) >> 1),
			true, getBackground(), this);
	}

	//////////////////////////////////////////////////////////////////////

	private ImageMap map;
	private int speed;
	private int frame, stop_frame;
	private int delta_t;
	private Thread anim_thread;
}
