//////////////////////////////////////////////////////////////////////
// ActionItem: menu item with callback.

#include <utility/misc.jinc>

package utility;

import java.awt.*;
import java.awt.event.*;

public abstract class ActionItem extends MenuItem implements ActionListener
{
	public ActionItem(String text)
	{
		super(text);
		addActionListener(this);
	}

	public ActionItem(boolean en, String text)
	{
		this(text);
		setEnabled(en);
	}

	abstract public void doAction();

	public void actionPerformed(ActionEvent e)
	{
		doAction();
	}
}
