//////////////////////////////////////////////////////////////////////
// AppHelperApplet: helper-aware applet (allows out-of-browser activation).

#include <utility/misc.jinc>

#define LLOG(x) // RLOG(x)

package utility;

import java.applet.*;
import java.net.URL;
import java.awt.*;

public class AppHelperApplet extends Applet implements AppHelper
{
	public AppHelperApplet(AppHelper helper) { this.helper = helper; }
	public AppHelperApplet() {}

	public void init()
	{
		GUtil.applet = this;
		GUtil.helper = helper != null ? helper : this;
	}

	public void destroy()
	{
		QuitMap.quit();
	}

	public URL getDocumentBase()
	{ return (helper != null ? helper.getDocumentBase() : super.getDocumentBase()); }

	public URL getCodeBase()
	{ return (helper != null ? helper.getCodeBase() : super.getCodeBase()); }

	public String getParameter(String key)
	{ return (helper != null ? helper.getParameter(key) : super.getParameter(key)); }

	public String getParameter(String key, String def)
	{
		String value = getParameter(key);
		return value != null ? value : def;
	}

	public Image getImage(URL url)
	{
		LLOG("AppHelperApplet.getImage <- " + (url == null ? "null" : url.toString()));
		Image image = helper != null ? helper.getImage(url)
			: Toolkit.getDefaultToolkit().getImage(url);
		LLOG("//AppHelperApplet.getImage -> " + (image == null ? "null" : image.toString()));
		return image;
	}

	public Image getImage(URL base, String name)
	{
/*		try
		{
			URL url = new URL(base, name);
//            LOG("URL=" + url);
		}
		catch(Exception e)
		{
		}
*/
//        LOG("getImage <- base " + (base == null ? "null" : base.toString()) + ", name = " + (name == null ? "null" : name));
		LLOG("AppHelperApplet.getImage(" + name + ")");
		Image image = helper != null ? helper.getImage(base, name) : super.getImage(base, name);
//        LOG("getImage -> " + (image == null ? "null" : image.toString()));
		return image;
	}

	public Image getCodeImage(String name)
	{
		return getImage(getDocumentBase(), image_prefix + name + image_suffix);
	}

	public  String    image_prefix = "", image_suffix = ".gif";
	private AppHelper helper;
}
