//////////////////////////////////////////////////////////////////
// ImageMap: a bunch of masked icons packed in a single Image.

#include <utility/misc.jinc>

#define LLOG(x) // RLOG(x)

package utility;

import java.awt.*;
import java.awt.image.*;
import java.util.*;

public class ImageMap
{
/*
	public ImageMap(Component component, int cx, int cy, int item, Image image)
	{
		this.size = new Dimension(cx, cy);
		this.item = item;
		this.item_size = new Dimension(item, cy);
		this.image = image;
//		this.mask_height = 4 * cy;
	}
*/

	public ImageMap(int cx, int cy, int item, String fn)
	{
		this.size = new Dimension(cx, cy);
		this.item = item;
		this.item_size = new Dimension(item, cy);
		this.imagefile = fn;
//		this.mask_height = 4 * cy;
//		this(component, cx, cy, item, );
	}

	public Image     getImage(Color bg)
	{
		Image im = (Image)images.get(bg);
		if(im == null)
		{
			im = GUtil.getCodeImage(imagefile + "&BG=" + Util.ctohex(bg));
			LLOG("getImage(" + bg + ") -> " + im + ", " + im.getWidth(null) + " x " + im.getHeight(null));
			images.put(bg, im);
		}
		return im;
	}

	public Dimension getSize()      { return size; }
	public int       getWidth()     { return size.width; }
	public int       getHeight()    { return size.height; }
	public int       getItemWidth() { return item; }
	public Dimension getItemSize()  { return item_size; }
	public int       getCount()     { return size.width / item_size.width; }

/*
	public void drawImage(Graphics g, Point pos, boolean enabled, ImageObserver o)
	{
		drawImage(g, new Rectangle(pos, item_size), enabled, o);
	}
*/
/*
	public void drawImage(Graphics g, Point pos, Dimension out_size, boolean enabled, ImageObserver o)
	{
		drawImage(g, new Rectangle(pos, out_size), enabled, o);
	}
*/

/*
	public void drawImage(Graphics g, Rectangle rc, boolean enabled, ImageObserver o)
	{
		int y = enabled ? 0 : size.height;
		g.drawImage(image, rc.x, rc.y, rc.width, rc.height,
			0, y, size.width, y + size.height, o);
	}
*/
/*
	public void drawImage(Graphics g, int index, Point pos, boolean enabled, ImageObserver o)
	{
		drawImage(g, index, new Rectangle(pos, item_size), enabled, o);
	}
*/
/*
	public void drawImage(Graphics g, int index, Point pos, Dimension out_size, boolean enabled, ImageObserver o)
	{
		drawImage(g, index, new Rectangle(pos, out_size), enabled, o);
	}
*/
/*
	public void drawImage(Graphics g, int index, Rectangle rc, boolean enabled, ImageObserver o)
	{
		int x = index * item, y = (enabled ? 0 : size.height);
		g.drawImage(image,
			rc.x, rc.y, rc.x + rc.width, rc.y + rc.height, x, y, x + item, y + size.height, o);
	}
*/
/*
	public void drawImage(Graphics g, Point pos, boolean enabled, Color bg, ImageObserver o)
	{
		drawImage(g, new Rectangle(pos, item_size), enabled, bg, o);
	}
*/
/*
	public void drawImage(Graphics g, Point pos, Dimension out_size, boolean enabled, Color bg, ImageObserver o)
	{
		drawImage(g, new Rectangle(pos, out_size), enabled, bg, o);
	}
*/
/*
	public void drawImage(Graphics g, Rectangle rc, boolean enabled, Color bg, ImageObserver o)
	{
		int y = (enabled ? 0 : size.height);
		g.drawImage(image, rc.x, rc.y, rc.width, rc.height,
			0, y, size.width, y + size.height, bg, o);
	}
*/
	public void drawImage(Graphics g, int index, Point pos, boolean enabled, Color bg, ImageObserver o)
	{
		drawImage(g, index, new Rectangle(pos, item_size), enabled, bg, o);
	}

/*
	public void drawImage(Graphics g, int index, Point pos, Dimension size, boolean enabled, Color bg, ImageObserver o)
	{
		drawImage(g, index, new Rectangle(pos, size), enabled, bg, o);
	}
*/

	public void drawImage(Graphics g, int index, Rectangle rc, boolean enabled, Color bg, ImageObserver o)
	{
		int x = index * item, y = (enabled ? 0 : size.height);
		g.drawImage(getImage(bg),
			rc.x, rc.y, rc.x + rc.width, rc.y + rc.height,
			x, y, x + item, y + size.height, bg, o);
	}

	private Hashtable images = new Hashtable();
	private String imagefile;
	private Dimension size, item_size;
//	private int mask_height;
	private int item;
//    private boolean finished;
//    private Vector observers;
}
