//////////////////////////////////////////////////////////////////////
// MessageBox: simple dialog showing a message.

#include <utility/misc.jinc>

package utility;

import java.awt.*;
import utility.formatting.*;

public class MessageBox extends ModalDialog
{
	public MessageBox(Component owner, String text)
	{
		super(owner, t_("Warning"));
		para = new Paragraph();
		para.add(text, super.getFont());
//		new Font("SansSerif", Font.PLAIN, 14));
		setDlgSize(para_width = 300, 0);
		int ht = para.getHeight(para_width);
		Dimension but = GUtil.getButtonSize();
		add(new Rectangle((para_width - but.width) >> 1, ht + 10, but.width, but.height),
			new ActionButton(t_("OK"))
			{ public void doAction() { endModalLoop(1); } });
	}

	public void paint(Graphics g)
	{
		super.paint(g);
//        Dimension dim = getClientSize();
//		g.drawLine(0, 0, dim.width, dim.height);
		para.paint(g, new Point(0, 0), para_width);
	}

	private Paragraph para;
	private int para_width;
}
