//////////////////////////////////////////////////////////////////////
// Splitter: split window with resizing thumbs.

#include <utility/misc.jinc>

#define LLOG(x) // RLOG(x)

package utility;

import java.awt.*;
import java.awt.event.*;

public class Splitter extends Container
{
	CATCH_EVENTS()

#ifndef _DEBUG
	public void processEvent(AWTEvent e)
	{
		try                 { super.processEvent(e); }
		catch(Exception ex) { Util.println("Splitter event error"); }
	}
#endif

	public Splitter()
	{
		repaint_thread = new DelayedThread(500)
		{
			protected void timer()
			{
				LLOG("Splitter.doWork / invalidate, this = " + Splitter.this);
//				LLOG("parent = " + Splitter.this.getParent().isValid());
//				layChildren();
				repaint_layout();
//				Splitter.this.invalidate();
//				Splitter.this.validate();
//				repaint();/*doLayout();*/
//				Splitter.this.validate();
				LLOG("//Splitter.doWork / validate, dirty_layout = " + dirty_layout + ", this = " + Splitter.this);
			}
		};
		setForeground(GUtil.whiteGray);
		setBackground(SystemColor.control);
		adapter = new DragDropAdapter(this)
		{
			protected boolean doPush(Point pt)
			{
				if(!isSplit(pt) || comp2 == null || style != BOTH)
					return false;
				old_pos = getPos();
				Point pos = comp2.getLocation();
				delta = (Splitter.this.horizontal ? pos.x : pos.y);
				repaint();
				repaint_thread.set();
				return true;
			}

			protected Cursor getCursor(Point pt)
			{
				return (isDown || isSplit(pt)) && comp2 != null && style == BOTH
				? Cursor.getPredefinedCursor(Splitter.this.horizontal ? Cursor.E_RESIZE_CURSOR : Cursor.S_RESIZE_CURSOR)
				: null;
			}

			protected void doDrag(Point p, Point l, Point n)
			{
//				LLOG("doDrag!");
				if(n != null && comp2 != null && style == BOTH)
				{
					int sh = (horizontal ? n.x - p.x : n.y - p.y);
//					LLOG("sh = " + sh);
					int sh1 = Math.min(sh, 0), sh2 = Math.max(sh, 0);
					Point pos1 = comp1.getLocation(), pos2 = comp2.getLocation();
					Dimension size1 = comp1.getSize();
					Insets insets = getInsets();
					if(horizontal)
					{
						pos1.x = sh1 + insets.left;
						pos2.x = sh2 + delta;
					}
					else
					{
						pos1.y = sh1 + insets.top;
						pos2.y = sh2 + delta;
					}
					comp1.setLocation(pos1);
					comp2.setLocation(pos2);
				}
			}

			protected void doDrop(Point p, Point e)
			{
				if(comp2 == null || style != BOTH)
					return;
				Dimension dim = Splitter.this.getSize();
				Insets insets = Splitter.this.getInsets();
				delta -= Splitter.this.gap >> 1;
				int num = delta - (Splitter.this.gap >> 1), den;
				if(horizontal)
				{
					num += e.x - p.x - insets.left;
					den = dim.width - insets.left - insets.right;
				}
				else
				{
					num += e.y - p.y - insets.top;
					den = dim.height - insets.top - insets.bottom;
				}
				LLOG("Splitter.doDrop: num = " + num + ", den = " + den);
				if(den > 0)
					Splitter.this.setPos(num * 10000 / den);
			}

			protected void doCancel()
			{
				setPos(old_pos);
				repaint();
				repaint_thread.set();
			}

			protected void doSelect(Point start, Point end) { doCancel(); }

			private int delta;
			private int old_pos;
		};
	}

/*
	public void setInv()
	{
		LLOG("Splitter.setInv, valid = " + isValid());
		invalidate();
		repaint();
		LLOG("//Splitter.setInv, valid = " + isValid());
	}
*/

	public void setHorz(Component a, Component b, int pos)
	{
		LLOG("Splitter.setHorz");
		removeAll();
		horizontal = true;
		if(a != null) add(a);
		if(b != null) add(b);
		this.pos = pos;
//		doLayout();
		invalidate();
		validate();
	}

	public void setVert(Component a, Component b, int pos)
	{
		LLOG("Splitter.setVert");
		removeAll();
		horizontal = false;
		if(a != null) add(a);
		if(b != null) add(b);
		this.pos = pos;
//		doLayout();
		invalidate();
		validate();
	}

	public int getGapWidth()            { return gap; }
	public void setGapWidth(int _gap)   { gap = _gap; invalidate(); /* validate(); */ }

	public static final int FIRST = 1;
	public static final int SECOND = 2;
	public static final int BOTH = 3;

	public void setStyle(int st)        { style = st; invalidate(); /* validate(); */ /*doLayout();*/ }

	public boolean is3DThumb()          { return thumb3d; }
	public void set3DThumb(boolean _3d) { thumb3d = _3d; invalidate(); /* validate(); */ }

	public Insets getInsets()           { return new Insets(0, 0, 0, 0); }

/*
	public void invalidate()
	{
		LLOG("Splitter.invalidate");
		super.invalidate();
		LLOG("//Splitter.invalidate");
	}
*/

/*
	public void validate()
	{
		LLOG("Splitter.validate, valid = " + isValid());
		super.validate();
		LLOG("//Splitter.validate, valid = " + isValid());
	}
*/

	public void doLayout()
	{
		LLOG("Splitter.doLayout" + (horizontal ? "(horz)" : "(vert)"));
//		LLOG("thread = " + Thread.currentThread().getName());
//	Thread.currentThread().dumpStack();
		super.doLayout();

		synchronized(this)
		{
			if(dragging || laying)
				return;
			laying = true;
		}

		layChildren();
		laying = false;
		repaint();
	}

	private void layChildren()
	{
		Insets insets = getInsets();
		Dimension size = getSize();
		LLOG("Splitter.layChildren, size = " + size + ", insets = " + insets);
		vport = Util.sub(size, insets.left + insets.right, insets.top + insets.bottom);
		comp1 = comp2 = null;
		for(int i = 0, n = getComponentCount(); comp2 == null && i < n; i++)
		{
			Component c = getComponent(i);
//			if(c.isVisible())
			if(comp1 == null)
				comp1 = c;
			else
				comp2 = c;
		}

		if(vport.width <= 0 || vport.height <= 0 || comp1 == null)
		{
			LLOG("Splitter.layChildren / NONE");
			repaint();
			return;
		}

		if(comp2 == null || style == FIRST)
		{
			LLOG("Splitter.layChildren / FIRST");
			comp1.setBounds(insets.left, insets.top, vport.width, vport.height);
			comp1.setVisible(true);
			if(comp2 != null)
				comp2.setVisible(false);
//			comp1.invalidate();
//			comp1.validate();
//			comp1.doLayout();
//			comp1.validate();
			return;
		}

		if(style == SECOND)
		{
			LLOG("Splitter.layChildren / SECOND");
			comp1.setVisible(false);
			comp2.setBounds(insets.left, insets.top, vport.width, vport.height);
			comp2.setVisible(true);
//			comp2.invalidate();
//			comp2.validate();
//			comp2.doLayout();
//			comp2.validate();
			return;
		}

		LLOG("Splitter.layChildren / BOTH");
		comp1.setVisible(true);
		comp2.setVisible(true);
		int amount;
		if(horizontal)
		{
			amount = pos * (vport.width - gap) / 10000;
			comp1.setBounds(insets.left, insets.top, amount, vport.height);
			LLOG("Splitter(horz).layChildren: " + comp1 + ".setBounds " + comp1.getBounds());
			comp2.setBounds(insets.left + amount + gap, insets.top, vport.width - gap - amount, vport.height);
			LLOG("Splitter(horz).layChildren: " + comp2 + ".setBounds " + comp2.getBounds());
		}
		else
		{
			amount = pos * (vport.height - gap) / 10000;
			comp1.setBounds(insets.left, insets.top, vport.width, amount);
			comp2.setBounds(insets.left, insets.top + amount + gap, vport.width, vport.height - gap - amount);
		}
//		comp1.invalidate();
//		comp1.doLayout();
//		comp1.validate();
//		comp2.invalidate();
//		comp2.doLayout();
//		comp2.validate();
//		comp1.validate();
//		comp2.validate();

		LLOG("//Splitter.layChildren");
	}

	public synchronized boolean isSplit(Point pt)
	{
		if(comp2 == null || style != BOTH)
			return false;
		Rectangle rc = comp2.getBounds();
		if(horizontal)
			return pt.x < rc.x && pt.x >= rc.x - gap;
		else
			return pt.y < rc.y && pt.y >= rc.y - gap;
	}

	public int getPos() { return pos; }

	public synchronized void setPos(int pos)
	{
		this.pos = (pos >= 10000 ? 10000 : pos <= 0 ? 0 : pos);
		repaint_thread.set();
	}

	public synchronized void repaint_layout()
	{
		dirty_layout = true;
		LLOG("Splitter.repaint_layout -> dirty_layout = " + dirty_layout + ", this = " + this);
		repaint();
	}

	public void paint(Graphics g)
	{
		LLOG("Splitter.paint, dirty_layout = " + dirty_layout + ", this = " + this);
		if(dirty_layout)
		{
			LLOG("Splitter.paint -> layout");
			dirty_layout = false;
			invalidate();
			validate();
//			doLayout();
			LLOG("//Splitter.paint -> layout");
		}
		super.paint(g);

		if(comp2 == null || style != BOTH)
			return;

		LLOG("Splitter.paint -> dim");
		Dimension dim = getSize();
		g.setColor(getBackground());
		if(!thumb3d)
		{
			LLOG("Splitter.paint -> !thumb3d");
			if(horizontal)
				g.fillRect(pos, 0, gap, dim.height);
			else
				g.fillRect(0, pos, dim.width, gap);
			return;
		}
		Rectangle rc = comp2.getBounds();
		if(horizontal)
		{
			LLOG("Splitter.paint -> horizontal");
			int pos = rc.x - gap;
			g.fillRect(pos + 2, 0, gap - 4, dim.height);
			GUtil.fillRect(g, pos, 0, 1, dim.height, SystemColor.control);
			GUtil.fillRect(g, pos + 1, 0, 1, dim.height, Color.white);
			GUtil.fillRect(g, pos + gap - 2, 0, 1, dim.height, Color.gray);
			GUtil.fillRect(g, pos + gap - 1, 0, 1, dim.height, Color.black);
		}
		else
		{
			LLOG("Splitter.paint -> vertical");
			int pos = rc.y - gap;
			g.fillRect(0, pos + 2, dim.width, gap - 4);
			GUtil.fillRect(g, 0, pos, dim.width, 1, SystemColor.control);
			GUtil.fillRect(g, 0, pos + 1, dim.width, 1, Color.white);
			GUtil.fillRect(g, 0, pos + gap - 2, dim.width, 1, Color.gray);
			GUtil.fillRect(g, 0, pos + gap - 1, dim.width, 1, Color.black);
		}

		LLOG("//Splitter.paint");
	}

	private int pos = 5000;
	private int gap = 8;
	private boolean horizontal;
	private boolean laying = false;
	private DragDropAdapter adapter;
	private boolean dragging = false;
	private boolean thumb3d = false;
	private boolean dirty_layout = true;
	private DelayedThread repaint_thread;
	private Dimension vport = new Dimension(1, 1);
	private Component comp1, comp2;
	private int style = BOTH;
}
