///////////////////////////////////////////////////////////////////
// StatusBar: status bar displaying text or progress indicator.

#include <utility/misc.jinc>

#define LLOG(x) // RLOG(x)

package utility;

import java.awt.*;

public class StatusBar extends Canvas
{
	public StatusBar() {}

	public void setDefault(String d)
	{
		if(d == null) d = "";
		LLOG("StatusBar.setDefault(" + d + ")");
		if(!default_text.equals(d))
		{
			default_text = d;
			syncPaint();
		}
		LLOG("//StatusBar.setDefault");
	}

	public void setLeft(String l, int p)
	{
		if(l == null) l = "";
		LLOG("StatusBar.setLeft(" + l + ", " + p + ")");
		if(!left_text.equals(l))
		{
			left_text = l;
			progress = p;
			//repaint();
			LLOG("setLeft(" + l + ", " + p + ")");
			syncPaint();
		}
		LLOG("//StatusBar.setLeft");
	}
	public void setLeft(String l)        { setLeft(l, -1); }
	public void setRight(String r)       { right_text = r; repaint(); }

	public void syncPaint()
	{
		if(isShowing())
		{
			LLOG("StatusBar.syncPaint(showing)");
			Graphics g = getGraphics();
			if(g != null)
			{
				paint(g);
				g.dispose();
			}
			LLOG("//StatusBar.syncPaint");
		}
	}

	public void paint(Graphics g)
	{
		Dimension dim = getSize();
//		GUtil.fillRect(g, 0, 0, dim.width, dim.height, getBackground());
		g.setFont(getFont());
		FontMetrics metrics = g.getFontMetrics();
		int ytext = ((dim.height - metrics.getHeight()) >> 1) + metrics.getAscent();
		String ltext = (left_text.length() > 0 ? left_text : default_text.length() > 0 ? default_text : t_("Ready"));
		int lpos = metrics.stringWidth(ltext) + 12;
		GUtil.fillRect(g, 0, 0, lpos, dim.height, getBackground());
		g.setColor(getForeground());
		g.drawString(ltext, 4, ytext);
		int rpos = dim.width - 4 - metrics.stringWidth(right_text);
		GUtil.fillRect(g, rpos, 0, dim.width - rpos, dim.height, getBackground());
		g.setColor(getForeground());
		g.drawString(right_text, rpos, ytext);
		int mpos = lpos;
		if(progress >= 0)
		{
			int wd = Util.min(200, rpos - 8 - lpos);
			if(wd >= 20)
			{
				GUtil.fillRect(g, lpos, 0, wd, dim.height, getBackground());
				mpos += wd;
				int ht = PROGRESS_HT;
				int ypos = (dim.height - ht) >> 1;
				GUtil.drawRect(g, lpos + 0, ypos + 0, wd - 0, ht - 0, 1, Color.gray, Color.white);
				GUtil.drawRect(g, lpos + 1, ypos + 1, wd - 2, ht - 2, 1, Color.black, Color.lightGray);
				lpos += 2;
				ypos += 2;
				wd   -= 4;
				ht   -= 4;
				int div = progress * wd / 100;
				GUtil.fillRect(g, lpos, ypos, div, ht, Color.red);
				GUtil.fillRect(g, lpos + div, ypos, wd - div, ht, Color.white);
			}
		}
		GUtil.fillRect(g, mpos, 0, rpos - mpos, dim.height, getBackground());
	}

	private String left_text = "";
	private String default_text = "";
	private String right_text = "";
	private int    progress = -1;
	private static final int PROGRESS_HT = 12;
}
