///////////////////////////////////////////////////////////////////
// Strut: vertical strut for separating toolbar sections.

#include <utility/misc.jinc>

package utility;

import java.awt.*;

public class Strut extends Canvas
{
	public Strut(boolean e, Dimension d, Color bg) { empty = e; dim = d; setBackground(bg); }
	public Strut()                                 { this(false, new Dimension(10, 22), SystemColor.control); }
	public Strut(Dimension dim)                    { this(false, dim, SystemColor.control); }
	public Strut(boolean empty, Dimension dim)     { this(empty, dim, SystemColor.control); }
	public Strut(boolean empty)                    { this(empty, new Dimension(empty ? 5 : 10, 22), SystemColor.control); }
	public Strut(boolean empty, Color bg)          { this(empty, new Dimension(empty ? 5 : 10, 22), bg); }

	public Dimension getPreferredSize() { return dim; }

	public void paint(Graphics g)
	{
		if(!empty)
		{
			Dimension dim = getSize();
			int mid = dim.width >> 1;
			GUtil.drawRect(g, mid - 0, 0, 1, dim.height, 1, Color.white);
			GUtil.drawRect(g, mid - 1, 0, 1, dim.height, 1, Color.black);
		}
	}

	private Dimension dim;
	private boolean empty;
}
