#include <utility/misc.jinc>

package utility;

import java.awt.*;
import java.util.*;

#define LLOG(x) // RLOG(x)

public class XmlParser {
	public static class XmlError extends Exception
	{
		public XmlError(String text) { super(text); }
	};

	public XmlParser(String s) throws XmlError { this(s, 0); }
	public XmlParser(String s, int start_pos) throws XmlError
	{
		parsed_text = (s != null ? s : "");
		length = parsed_text.length();
		term = Util.min(start_pos, length);
		Next();
	}

	private void Ent(StringBuffer out)
	{
		int outconst = 0;
		int t = ++term;
		if(At(t) == '#') {
			if(At(++t) == 'X' || At(t) == 'x') {
				for(int c; (c = Util.ctoi(At(++t))) < 16; outconst = 16 * outconst + c)
					;
			}
			else {
				while(Util.isdigit(At(t)))
					outconst = 10 * outconst + At(t++) - '0';
			}
//			out.Cat(ToUtf8(outconst));
			out.append(outconst);
			term = t;
			return;
		}
		if(At(t + 0) == 'l' && At(t + 1) == 't' && At(t + 2) == ';') {
			t += 3;
			out.append('<');
		}
		else
		if(At(t + 0) == 'g' && At(t + 1) == 't' && At(t + 2) == ';') {
			t += 3;
			out.append('>');
		}
		else
		if(At(t) == 'a') {
			if(At(t + 1) == 'm' && At(t + 2) == 'p' && At(t + 3) == ';') {
				t += 4;
				out.append('&');
			}
			else if(At(t + 1) == 'p' && At(t + 2) == 'o' && At(t + 3) == 's' && At(t + 4) == ';') {
				t += 5;
				out.append('\'');
			}
		}
		else
		if(At(t + 0) == 'q' && At(t + 1) == 'u' && At(t + 2) == 'o' && At(t + 3) == 't' && At(t + 4) == ';') {
			t += 5;
			out.append('\"');
		}
		else {
			out.append('&');
		}
		term = t;
	}
	
	private void Next() throws XmlError
	{
		StringBuffer textbuf = new StringBuffer();
		text = "";
		if(empty_tag) {
			empty_tag = false;
			type = XML_END;
			return;
		}
		type = XML_EOF;
		if(!npreserve)
			SkipWhites();
		if(At(term) == '<') {
			term++;
			if(At(term) == '!') {
				type = XML_DECL;
				term++;
				if(At(term + 0) == '-' && At(term + 1) == '-') {
					type = XML_COMMENT;
					term += 2;
					for(;;) {
						if(At(term + 0) == '-' && At(term + 1) == '-' && At(term + 2) == '>')
							break;
						if(term >= length) {
							throw new XmlError("Unterminated comment");
//							type = XML_EOF;
//							return;
						}
						if(At(term) == '\n')
							line++;
						textbuf.append(At(term++));
					}
					term += 3;
					text = textbuf.toString();
					return;
				}
				for(;;) {
					if(At(term) == '>') {
						term++;
						break;
					}
					if(term >= length)
						throw new XmlError("Unterminated declaration");
					if(At(term) == '\n')
						line++;
					textbuf.append(At(term++));
				}
			}
			else
			if(At(term) == '?') {
				type = XML_PI;
				term++;
				for(;;) {
					if(At(term + 0) == '?' && At(term + 1) == '>') {
						term += 2;
						text = textbuf.toString();
						return;
					}
					if(term >= length)
						throw new XmlError("Unterminated processing info");
					if(At(term) == '\n')
						line++;
					textbuf.append(At(term++));
				}
			}
			else
			if(At(term) == '/') {
				type = XML_END;
				term++;
				int t = term;
				while(IsXmlNameChar(At(term)))
					term++;
				text = parsed_text.substring(t, term - t);
				if(At(term) != '>')
					throw new XmlError("Unterminated end-tag");
				term++;
			}
			else {
				type = XML_TAG;
				int t = term;
				while(IsXmlNameChar(At(term)))
					term++;
				text = parsed_text.substring(t, term - t);
				nattr_keys = new Vector();
				nattr_values = new Vector();
				for(;;) {
					SkipWhites();
					if(At(term) == '>') {
						term++;
						break;
					}
					if(At(term + 0) == '/' && At(term + 1) == '>') {
						empty_tag = true;
						term += 2;
						break;
					}
					if(term >= length)
						throw new XmlError("Unterminated tag");
					t = term++;
					while(At(term) > ' ' && At(term) != '=' && At(term) != '>')
						term++;
					String attr = parsed_text.substring(t, term);
					SkipWhites();
					if(At(term) == '=') {
						term++;
						SkipWhites();
						StringBuffer attrval = new StringBuffer();
						if(At(term) == '\"') {
							term++;
							while(term < length && At(term) != '\"')
								if(At(term) == '&')
									Ent(attrval);
								else {
									int e = term;
									while(++e < length && At(e) != '&' && At(e) != '\"')
										;
									attrval.append(parsed_text.substring(term, e - term));
									term = e;
								}
							if(At(term) == '\"')
								term++;
						}
						else {
							while(At(term) > ' ' && At(term) != '>')
								if(At(term) == '&')
									Ent(attrval);
								else {
									int e = term;
									while(At(++e) > ' ' && At(e) != '>' && At(e) != '&')
										;
									attrval.append(parsed_text.substring(term, e - term));
									term = e;
								}
						}
						if(attr.equals("xml:space") && attrval.equals("preserve"))
							npreserve = true;
						String aval = attrval.toString(); //FromUtf8(~attrval, attrval.GetLength()).ToString();
						nattr_keys.addElement(attr);
						nattr_values.addElement(aval);
					}
				}
			}
		}
		else if(term >= length)
			type = XML_EOF;
		else {
			StringBuffer raw_text = new StringBuffer();
			while(At(term) != '<' && term < length) {
				if(At(term) == '\n')
					line++;
				if(At(term) == '&')
					Ent(raw_text);
				else {
					int e = term;
					while(e < length && At(e) != '&' && At(e) != '<')
						;
					raw_text.append(parsed_text.substring(term, e - term));
					term = e;
				}
			}
			int re = raw_text.length();
			if(!npreserve) {
				while(re > 0 && raw_text.charAt(re - 1) <= ' ')
					re--;
			}
			text = raw_text.toString(); //FromUtf8(~raw_text, re - ~raw_text).ToString();
			type = XML_TEXT;
		}
	}

	public void SkipWhites()
	{
		while(term < length && At(term) <= ' ') {
			if(At(term) == '\n')
				line++;
			term++;
		}
	}

	public boolean IsEof()
	{
		return type == XML_EOF;
	}
	
	public boolean IsTag()
	{
		return type == XML_TAG;
	}
	
	public String ReadTag() throws XmlError
	{
		if(type != XML_TAG)
			throw new XmlError("Tag expected");
		LLOG("ReadTag " + text);
		String h = text;
		stack.addElement(new Nesting(h, npreserve));
		attr_keys = nattr_keys;
		attr_values = nattr_values;
		nattr_keys = new Vector();
		nattr_values = new Vector();
		Next();
		return h;
	}
	
	public boolean Tag(String tag) throws XmlError
	{
		if(IsTag() && text == tag) {
			LLOG("Tag " << text);
			stack.addElement(new Nesting(text, npreserve));
			attr_keys = nattr_keys;
			attr_values = nattr_values;
			nattr_keys = new Vector();
			nattr_values = new Vector();
			Next();
			return true;
		}
		return false;
	}
	
	public void PassTag(String tag) throws XmlError
	{
		if(!Tag(tag))
			throw new XmlError("Tag expected: " + tag);
	}
	
	public boolean IsEnd()
	{
		return type == XML_END;
	}
	
	public boolean End() throws XmlError
	{
		if(IsEof())
			throw new XmlError("Unexpected end of file");
		if(IsEnd()) {
			LLOG("EndTag " << text);
			if(stack.size() == 0)
				throw new XmlError("Unexpected end-tag: " + text);
			Nesting top = (Nesting)stack.elementAt(stack.size() - 1);
			if(top.tag != text) {
				RLOG("Tag/end-tag mismatch: <" + top.tag + "> </" + text + ">");
	//			throw XmlError(NFormat("Tag/end-tag mismatch: <%s> </%s>", stack.Top().tag, text));
			}
			stack.removeElementAt(stack.size() - 1);
			npreserve = (stack.size() > 0 && ((Nesting)stack.elementAt(stack.size() - 1)).preserve_blanks);
			Next();
			return true;
		}
		return false;
	}
	
	public void PassEnd() throws XmlError
	{
		if(!End())
			throw new XmlError("Expected end-tag: " + (stack.size() > 0
				? ((Nesting)stack.elementAt(stack.size() - 1)).tag
				: ""));
	}
	
	public boolean TagE(String tag) throws XmlError
	{
		if(Tag(tag)) {
			PassEnd();
			return true;
		}
		return false;
	}
	
	public void PassTagE(String tag) throws XmlError
	{
		PassTag(tag);
		PassEnd();
	}

	public int GetAttrCount()
	{ 
		return attr_keys.size();
	}
	
	public int FindAttr(String name)
	{
		for(int i = 0; i < attr_keys.size(); i++)
			if(name.equals((String)attr_keys.elementAt(i)))
				return i;
		return -1;
	}

/*
	public String GetAttr(int i) const
	{ return i ? attr.GetKey(i - 1) : attr1;
	}
	public String operator[](int i) const                            { return i ? attr[i - 1] : attrval1; }
	public String operator[](const char *id) const                   { return attr1 == id ? attrval1 : attr.Get(id, Null); }
*/

	public int Int(String id) { return Int(id, Util.INT_NULL); }
	public int Int(String id, int def)
	{
		int q = FindAttr(id);
		return q < 0 ? def : Util.atoi((String)attr_values.elementAt(q));
	}
	
	public double Double(String id) { return Double(id, Util.DBL_NULL); }
	public double Double(String id, double def)
	{
		int q = FindAttr(id);
		return q < 0 ? def : Util.atof((String)attr_values.elementAt(q));
	}

	public boolean IsText()
	{
		return type == XML_TEXT;
	}
	
	public String ReadText() throws XmlError
	{
		if(!IsText())
			throw new XmlError("Character data expected");
		String h = text;
		Next();
		return h;
	}
	
	public String ReadTextE() throws XmlError
	{
		String out = new String();
		while(!IsEnd())
			if(IsText())
				out += ReadText();
			else
				Skip();
		PassEnd();
		return out;
	}

	public boolean IsDecl()
	{
		return type == XML_DECL;
	}
	
	public String ReadDecl() throws XmlError
	{
		if(!IsDecl())
			throw new XmlError("Declaration expected");
		String h = text;
		Next();
		return h;
	}

	public boolean IsPI()
	{
		return type == XML_PI;
	}
	
	public String ReadPI() throws XmlError
	{
		if(!IsPI())
			throw new XmlError("Processing info expected");
		String h = text;
		Next();
		return h;
	}

	public boolean IsComment()
	{
		return type == XML_COMMENT;
	}
	
	public String ReadComment() throws XmlError
	{
		if(!IsComment())
			throw new XmlError("Comment expected");
		String h = text;
		Next();
		return h;
	}

	public void Skip() throws XmlError
	{
		if(IsEof())
			throw new XmlError("Unexpected end of file");
		if(IsTag()) {
			String n = ReadTag();
			while(!End()) {
				if(IsEof())
					throw new XmlError("Unexpected end of file expected when skipping tag \'" + n + "\'");
				Skip();
			}
		}
		else
			Next();
	}
	
	public void SkipEnd() throws XmlError
	{
		while(!IsEnd()) Skip();
		PassEnd();
	}

	private char At(int i)
	{
		return i < length ? parsed_text.charAt(i) : '\0';
	}

	private static boolean IsXmlNameChar(char c)
	{
		return Util.isalnum(c) || c == '.' || c == '-' || c == '_' || c == ':';
	}

	public static final int XML_EOF = 0;
	public static final int XML_DOC = 1;
	public static final int XML_TAG = 2;
	public static final int XML_END = 2;
	public static final int XML_TEXT = 3;
	public static final int XML_DECL = 4;
	public static final int XML_PI = 5;
	public static final int XML_COMMENT = 6;

	private static class Nesting {
		Nesting(String tag, boolean blanks)
		{
			this.tag = tag;
			this.preserve_blanks = blanks;
		}
		String tag;
		boolean preserve_blanks;
	}

	private String            parsed_text;
	private int               length;
	private int               term;
	private Vector            stack = new Vector();

	private int               type;
	private Vector            attr_keys = new Vector();
	private Vector            attr_values = new Vector();
	private Vector            nattr_keys = new Vector();
	private Vector            nattr_values = new Vector();
	private String            text;
	private boolean           empty_tag = false;
	private boolean           npreserve = false;

	private int               line = 1;

}
