package utility.formatting;

import java.awt.*;
import java.util.*;
import utility.*;

public class Paragraph
{
	public Paragraph()
	{
	}

	public void clear()
	{
		items = new Vector();
		rows = null;
		last_width = last_height = last_min_width = 0;
	}

	public final boolean isEmpty() { return items.isEmpty(); }

	public final void add(int y_offset, DisplayItem item, int skip_after)
	{
		ItemInfo info = new ItemInfo();
		info.item = item;
		info.y_offset = y_offset;
		info.skip_after = skip_after;
//		info.allow_break = allow_break;
		items.addElement(info);
		rows = null; // force reformatting
	}

	public final void add(DisplayItem item, int skip_after)
	{ add(0, item, skip_after); }

	public final void add(int y_offset, String text, Font font, Graphics ref_context)
	{
		int pos = 0;
		int blank = ref_context.getFontMetrics().charWidth(' ');
		for(int next; (next = text.indexOf(' ', pos)) >= 0; pos = next + 1)
			add(y_offset, new TextDisplayItem(text.substring(pos, next), font, ref_context), blank);
		if(pos < text.length())
			add(y_offset, new TextDisplayItem(text.substring(pos), font, ref_context), 0);
	}

	public final void add(int y_offset, String text, Font font, Component ref_component)
	{
		Graphics g = ref_component.getGraphics();
		add(y_offset, text, font, g);
		g.dispose();
	}

	public final void add(int y_offset, String text, Font font)
	{ add(y_offset, text, font, GUtil.applet); }

	public final void add(int y_offset, String text)
	{ add(y_offset, text, GUtil.applet.getFont(), GUtil.applet); }

	public final void add(String text, Font font, Graphics g)  { add(0, text, font, g); }
	public final void add(String text, Font font, Component c) { add(0, text, font, c); }
	public final void add(String text, Font font)              { add(0, text, font); }
	public final void add(String text)                         { add(0, text); }

	public final void indent()
	{
		getLastInfo().command = INDENT;
	}

	public final void endIndent()
	{
		getLastInfo().command = END_INDENT;
	}

	public final void newLine()
	{
		getLastInfo().command = NEW_LINE;
	}

	public final void vskip(int amount)
	{
		ItemInfo info = getLastInfo();
		info.command = VSKIP;
		info.skip_after = amount;
	}

	protected final ItemInfo getLastInfo()
	{
		rows = null;
		ItemInfo info;
		if(items.isEmpty())
			items.addElement(info = new ItemInfo());
		else if((info = (ItemInfo)items.lastElement()).command != 0)
			items.addElement(info = new ItemInfo());
		return info;
	}

	synchronized public final void paint(Graphics g, Point location, int width)
	{
		try
		{
			if(width != last_width || rows == null)
				format(width);
			int index = 0;
			int y = location.y;
			int top = g.getClipBounds().y, bottom = top + g.getClipBounds().height;
			for(int i = 0; i < rows.size() && y < bottom; i++)
			{
				RowInfo row = (RowInfo)rows.elementAt(i);
				int x = location.x + row.x_start;
				if(y + row.height > top)
					for(int base = y + (row.ind_index > index ? row.indent_ascent : row.ascent);
						index < row.end_index; index++)
					{
						if(index == row.ind_index)
							base = y + row.ascent;
						ItemInfo info = (ItemInfo)items.elementAt(index);
						if(info.item != null)
						{
							info.item.paint(g, x, base - info.y_offset);
							x += info.item.getWidth();
						}
						x += info.skip_after;
					}
				index = row.end_index;
				y += row.height;
			}
		}
		catch(NullPointerException e)
		{
//			e.printStackTrace();
//			if(rows == null) LOG("rows = null");
//			if(items == null) LOG("items = null");
		}
	}

	public final int getHeight(int width)
	{
		format(width);
		return last_height;
	}

	public final int getMinWidth()
	{
		format(0);
		return last_min_width;
	}

	synchronized protected final void format(int width)
	{
//		LOG("format");
		Vector new_rows = new Vector();
		last_height = 0;
		last_min_width = 0;
		int x_start = 0;
		int indent_height = 0;
//		LOG("for");
		for(int index = 0; index < items.size();) {
//			LOG("row");
			RowInfo row = new RowInfo();
			int descent = 0, leading = 0, idescent = 0, rowindex = index;
			row.x_start = x_start;
			int full_width = x_start;

//			LOG("while");
			ROW:
			while(index < items.size()) {
				ItemInfo info = (ItemInfo)items.elementAt(index);
//				LOG("info");
				if(info.item != null) {
//					LOG("-> not null");
					int item_width = info.item.getWidth();
					last_min_width = Util.max(last_min_width, item_width + row.x_start);
					if(full_width > x_start && full_width + item_width > width)
						break;
					row.ascent = Math.max(row.ascent, info.item.getAscent() + info.y_offset);
					descent = Math.max(descent, info.item.getDescent() - info.y_offset);
					leading = Math.max(leading, info.item.getLeading());
					row.raw_width = full_width += item_width;
				}
				full_width += info.skip_after;
				index++;
//				LOG("info.command");
				switch(info.command)
				{
				case INDENT:
					row.ind_index = index;
					row.indent_ascent = row.ascent;
					idescent = descent;
					indent_height = row.indent_ascent + descent;
					row.ascent = descent = 0;
					x_start = full_width;
					break;

				case END_INDENT:
					if(row.ind_index > rowindex) {
						row.indent_ascent = row.ascent = Math.max(row.indent_ascent, row.ascent);
						descent = Math.max(descent, idescent);
						indent_height = 0;
					}
					leading = Math.max(leading, indent_height - row.ascent - descent);
					x_start = 0;
					break;

				case NEW_LINE:
					break ROW;

				case VSKIP:
					leading += info.skip_after;
					break ROW;
				}
			}
//			LOG("row.height");
			if(index >= items.size())
				leading = Math.max(leading, indent_height - row.ascent - descent);
			last_height += row.height = row.ascent + descent + leading;
			indent_height -= row.height;
			row.end_index = index;
//			LOG("rows.addElement");
			new_rows.addElement(row);
		}
		rows = new_rows;
		last_width = width;
//		LOG("//format");
	}

	private static class ItemInfo
	{
		DisplayItem item;
		int         skip_after; // skip after item / vskip (when command == VSKIP)
		int         y_offset; // item offset against baseline (positive = up)
		byte        command; // extra command attached to element
	};

	private static class RowInfo
	{
		int end_index; // item index past last item in this row
		int ind_index; // 1st item past indent, 0 = no indentation
		int raw_width; // raw width
		int x_start;   // start x coordinate
		int ascent, indent_ascent, height;
	};

	private Vector items = new Vector();
	private Vector rows;
	private int    last_width;
	private int    last_height;
	private int    last_min_width;

	private static final byte INDENT = 1;
	private static final byte END_INDENT = 2;
	private static final byte NEW_LINE = 3;
	private static final byte VSKIP = 4;
}
