package utility.formatting;

import java.awt.*;

public class StrutDisplayItem implements DisplayItem
{
	public StrutDisplayItem(int width, int ascent, int descent, int leading)
	{
		this.width = width;
		this.ascent = ascent;
		this.descent = descent;
		this.leading = leading;
	}

	public StrutDisplayItem(int width, int ascent, int descent) { this(width, ascent, descent, 0); }
	public StrutDisplayItem(int width, int ascent)              { this(width, ascent, 0, 0); }
	public StrutDisplayItem(int width)                          { this(width, 0, 0, 0); }

	public final void setWidth(int _width) { width = _width; }
	public final void setAscent(int _ascent) { ascent = _ascent; }
	public final void setDescent(int _descent) { descent = _descent; }
	public final void setLeading(int _leading) { leading = _leading; }

	public final int  getAscent()   { return ascent; }
	public final int  getDescent()  { return descent; }
	public final int  getLeading()  { return leading; }
	public final int  getWidth()    { return width; }

	public final void paint(Graphics g, int x, int y) {}

	private int width, ascent, descent, leading;
}
