//////////////////////////////////////////////////////////////////////
// DelayedThread: common scheme for doing posponed work.

#include <utility/misc.jinc>

#define LLOG(x) // RLOG(x)

package utility;

public abstract class DelayedThread
{
	static final int STD_DELAY = 500;
	static final int MIN_DELTA = 50;

	public DelayedThread() { this(STD_DELAY); }
	public DelayedThread(int delay)
	{
//		LLOG("DelayedThread(" + delay + "), " + this);
		this.std_delay = delay;
	}

	public void set()       { timer.set(this, std_delay); }
	public void set(int d)  { timer.set(this, d); }
	public void remove()    { timer.remove(this); }

	protected abstract void timer();

	private int std_delay;
	private long ticks;
	private static Timer timer = new Timer();

	private static class Timer implements Runnable, Quittable
	{
		public Timer()
		{
			events = new java.util.Vector();
		}

		public synchronized void set(DelayedThread dt, int delta)
		{
			restart = true;
			long ticks = delta + System.currentTimeMillis();
			for(int i = 0; i < events.size(); i++)
			{
				DelayedThread ti = (DelayedThread)events.elementAt(i);
				if(ti == dt)
				{
//					LLOG("DelayedThread.Timer.add(" + dt + ", " + delta + ") - time adjusted");
					if(ticks > ti.ticks)
						ti.ticks = ticks;
					return;
				}
			}
			dt.ticks = ticks;
			events.addElement(dt);
			LLOG("DelayedThread.Timer.add(" + dt + ", " + delta + ") - new entry (" + events.size() + " total)");
			if(!set)
			{
				set = true;
				QuitMap.add(this);
				Thread thread = new Thread(this);
				thread.setPriority(Thread.MIN_PRIORITY);
				thread.start();
				LLOG("DelayedThread.Timer.set -> thread = " + thread.getName());
			}
		}

		public synchronized void remove(DelayedThread dt)
		{
			for(int i = 0; i < events.size(); i++)
				if(events.elementAt(i) == dt)
				{
					LLOG("DelayedThread.Timer.remove(" + dt + ")");
					events.removeElementAt(i);
					restart = true;
					break;
				}
		}

		public synchronized void quit()
		{
			LLOG("DelayedThread.Timer.quit (" + events.size() + " events pending)");
			quitting = true;
			timer = new Timer();
		}

		public void run()
		{
			LLOG("DelayedThread.Timer.run, thread = " + Thread.currentThread().getName());
			while(!quitting)
			{
				try
				{
//					LLOG("DelayedThread.Timer.run / sleep");
					Thread.currentThread().sleep(MIN_DELTA);
//					LLOG("DelayedThread.Timer.run / after sleep");
				}
				catch(InterruptedException e)
				{
					LLOG("DelayedThread.Timer.run -> InterruptedException");
				}
				long ticks = System.currentTimeMillis();
				int i = 0;
				while(!quitting)
				{
//					LLOG("DelayedThread.Timer.run / scanning " + i + " on " + Thread.currentThread().getName());
					DelayedThread dt = null;
					synchronized(this)
					{
//						LLOG("DelayedThread.Timer.run / sync");
						if(restart)
						{
							i = 0;
							restart = false;
						}
//						LLOG("DelayedThread.Timer.run / quitting = " + quitting + ", #events = " + events.size());
						if(quitting || i >= events.size())
							break;
//						LLOG("DelayedThread.Timer.run / elementAt(" + i + ")");
						dt = (DelayedThread)events.elementAt(i);
						if(dt.ticks > ticks)
						{
							i++;
							continue;
						}
//						LLOG("DelayedThread.Timer.run / removing #" + i);
						events.removeElementAt(i);
					}
					LLOG("DelayedThread.Timer.run -> timer(" + dt + ")");
					dt.timer();
				}
			}
			LLOG("//DelayedThread.Timer.run (quit)");
			events.removeAllElements();
			QuitMap.remove(this);
		}

		public boolean quitting = false;
		public boolean set = false;
		public boolean restart = false;
		public java.util.Vector events;
	};
}
