//////////////////////////////////////////////////////////////////
// IconButton: icon button.

#include <utility/misc.jinc>

#define LLOG(x) // RLOG(x)
#define LDUMP(x) // RDUMP(x)

package utility;

import java.awt.*;
import java.util.*;

public class IconButton extends Component
{
	public static class Map
	{
		public Map() { list = new Vector(); }

		public void add(Component ib) { list.addElement(ib); }

		public void attach(Container toolbar)
		{
			for(int i = 0, n = list.size(); i < n; i++)
				toolbar.add((Component)list.elementAt(i));
		}

		public void setBackground(Color c)
		{
			for(int i = 0, n = list.size(); i < n; i++)
				((Component)list.elementAt(i)).setBackground(c);
		}

		public void setIndexCheck(int index, boolean info)
		{
 			for(int i = 0, n = list.size(); i < n; i++)
				if(list.elementAt(i) instanceof IconButton)
					((IconButton)list.elementAt(i)).setIndexCheck(index, info);
		}

		private Vector list;
	};

	//////////////////////////////////////////////////////////////////
	// button style

	public static final byte FLAT         = 0x00;
	public static final byte LOW          = 0x01;
	public static final byte HIGH         = 0x02;
	public static final byte UNDERLINE    = 0x04;
	public static final byte VISUALS_MASK = 0x0f;

	public static final byte REPEAT       = 0x10;
	public static final byte PUSH         = 0x20;

	public IconButton(ImageMap imageMap, int index, String text, int style)
	{
		setForeground(SystemColor.controlHighlight);
//		setForeground(Color.white);
		setBackground(SystemColor.control);
		this.style = (byte)style;
		this.imageMap = imageMap;
		this.index = index;
		this.text = text;
		this.font = GUtil.stdFont;
		adapter = new ActionAdapter(this) {
			public void doAction()  { if(push_enabled) { NOLOG("action"); IconButton.this.doAction(); NOLOG("/action"); } }
			public void doRefresh() { IconButton.this.repaint(); }
		};
		updateAdapter();
	}

	public IconButton(ImageMap imageMap, int index, String text) { this(imageMap, index, text, FLAT ); }
	public IconButton(String text, int style)                    { this(null    , 0    , text, style); }
	public IconButton(String text)                               { this(null    , 0    , text, FLAT ); }
	public IconButton(ImageMap imageMap, int index, int style)   { this(imageMap, index, null, style); }
	public IconButton(ImageMap imageMap, int index)              { this(imageMap, index, null, FLAT ); }
	public IconButton(byte style)                                { this(null    , 0    , null, style); }
	public IconButton()                                          { this(null    , 0    , null, FLAT ); }

	public IconButton setIcon(ImageMap m, int i)                 { imageMap = m; index = i; repaint(); return this; }
	public IconButton setIconMap(ImageMap m)                     { imageMap = m; repaint(); return this; }
	public ImageMap   getIconMap()                               { return imageMap; }
	public IconButton setIconIndex(int i)                        { index = i; repaint(); return this; }
	public int        getIconIndex()                             { return index; }

	public IconButton setText(String text)                       { this.text = text; repaint(); return this; }
	public String     getText()                                  { return text; }

	public IconButton setHelp(String info)                       { this.info = info; return this; }
	public String     getHelp()                                  { return info; }

	public IconButton setTextFont(Font font)                     { this.font = font; return this; }
	public Font       getTextFont()                              { return font; }

	public Color      getLightColor()                            { return light; }
	public Color      getDarkColor()                             { return dark; }
	public IconButton setColors(Color light, Color dark)         { this.light = light; this.dark = dark; repaint(); return this; }

	public Color      getTextColor()                             { return ctext; }
	public IconButton setTextColor(Color ct)                     { ctext = ct; return this; }

	protected void doAction() {}

	public void action(boolean animate)
	{
		if(!push_enabled)
			return;
		if(animate)
		{
			adapter.push();
			try { Thread.currentThread().sleep(20); } catch(Exception e) {}
			adapter.release();
		}
		else
			doAction();
	}

	public void    action() { doAction(); }

	public void    setCheck(boolean check, boolean info)
	{
		this.check = check;
		repaint();
//		if(check && info)
//			GUtil.setDefaultInfo(this.info);
	}

	public void    setIndexCheck(int index, boolean info) { setCheck(index == this.index, info); }
	public boolean isChecked()                            { return check; }

	public void    setPushEnabled(boolean pen)
	{
		if(push_enabled != pen)
		{
			push_enabled = pen;
			repaint();
		}
	}

	public boolean isPushEnabled()                       { return push_enabled; }

	public byte    getStyle()               { return style; }
	public synchronized void setStyle(byte _style)
	{
		if(style != _style)
		{
			style = _style;
			invalidate();
			validate();
			repaint();
			updateAdapter();
		}
	}

	private void updateAdapter()
	{
		if((style & REPEAT) != 0)
			adapter.setRepeat();
		else
			adapter.setNoRepeat();
		adapter.setPushAction((style & PUSH) != 0);
	}

	private static final int GAP = 4;

#define IGAPX 4
#define IGAPY 3

	public void paint(Graphics g)
	{
		LLOG("IconButton.paint, text = " + text);
//        LOG("Icon paint; #" + index + ", pushed = " + adapter.isPushed()
//            + ", entered = " + adapter.isEntered());
		Rectangle rc = new Rectangle(getSize());
		byte visuals = (byte)(style & VISUALS_MASK);

		GUtil.setDefaultInfo(adapter.isEntered() ? info : null, isEnabled() && push_enabled);

		if(isEnabled() && isPushEnabled() && (style & UNDERLINE) == 0)
		{
			if(adapter.isPushed() || check)
			{
				GUtil.drawRect(g, rc, 1, dark, light);
				Util.inflate(rc, -1);
				if(visuals == HIGH)
				{
					GUtil.drawRect(g, rc, 1, Color.gray, GUtil.whiteGray);
					Util.inflate(rc, -1);
				}
			}
			else if(visuals != FLAT || adapter.isEntered() || check)
			{
				GUtil.drawRect(g, rc, 1, light, dark);
				Util.inflate(rc, -1);
				if(visuals == HIGH)
				{
					GUtil.drawRect(g, rc, 1, GUtil.whiteGray, Color.gray);
					Util.inflate(rc, -1);
				}
			}
		}
		Dimension text_size = getTextSize(), icon_size = getIconSize();
		Dimension total_size = new Dimension(text_size.width + icon_size.width, Math.max(text_size.height, icon_size.height));
//		LOG("text size = " + text_size);
//		LOG("total size = " + total_size);
		Rectangle pos = Util.center(total_size, rc);
		if(push_enabled && adapter.isPushed())
			Util.move(pos, 1);
		Color bg = (check && !adapter.isPushed()
			? getForeground() : getBackground());
		g.setColor(bg);
		GUtil.fillRect(g, rc);
		if(icon_size.width > 0)
		{
			imageMap.drawImage(g, index, new Point(pos.x + IGAPX, pos.y + IGAPY), isEnabled() && push_enabled, bg, this);
			pos.x += icon_size.width;
		}
		LDUMP(text);
		LDUMP(text_size);
		if(text_size.width > 0)
		{
			g.setFont(font);
			FontMetrics metrics = g.getFontMetrics();
			Dimension tdim = GUtil.getTextSize(metrics, text);
			g.setColor(isEnabled() ? ctext : Color.gray);
			int tbase = pos.y + ((pos.height - tdim.height) >> 1) + metrics.getAscent();
			g.drawString(text, pos.x + IGAPX, tbase);
			if(isEnabled() && adapter.isEntered() && (style & UNDERLINE) != 0)
				g.fillRect(pos.x + IGAPX, tbase + 1, tdim.width, 1);
		}
	}

	public Dimension getMinimumSize() { return getPreferredSize(); }

	private Dimension getIconSize()
	{
		return (imageMap == null ? new Dimension(0, 0)
			: Util.add(imageMap.getItemSize(), 2 * IGAPX, 2 * IGAPY));
	}

	private Dimension getTextSize()
	{
		if(text == null)
			return new Dimension(0, 0);
		Dimension dim = GUtil.getTextSize(font, text);
		dim.width += 2 * IGAPX;
		dim.height = Util.max(dim.height + 2 * IGAPY, 16 + 2 * IGAPY);
		LLOG("IconButton text = " + text + " -> dim = " + dim);
		return dim;
	}

	public Dimension getPreferredSize()
	{
		Dimension text_size = getTextSize(), icon_size = getIconSize();
		return new Dimension(text_size.width + icon_size.width,
			Math.max(text_size.height, icon_size.height));
	}

	private Color light = Color.white, dark = Color.black, ctext = Color.black;
	private ActionAdapter adapter;
	private Font font;
	private ImageMap imageMap;
	private byte style;
	private boolean check, push_enabled = true;
	private int index;
	private String text;
	private String info;
}
