///////////////////////////////////////////////////////////////////
// LineLayout: linear layout (used for toolbars).

#include <utility/misc.jinc>

#define LLOG(x) // RLOG(x)

package utility;

import java.awt.*;

public class LineLayout implements LayoutManager2
{
	public LineLayout(int inner_gap, boolean nobreak) { this.inner_gap = inner_gap; this.nobreak = nobreak; }
	public LineLayout()                               { this(3, false); }

	public void  addLayoutComponent(String name, Component component) {}
	public void  addLayoutComponent(Component component, Object constraint) {}
	public void  removeLayoutComponent(Component component) {}
	public void  invalidateLayout(Container container) {}
	public float getLayoutAlignmentX(Container container) { return 0.0f; }
	public float getLayoutAlignmentY(Container container) { return 0.0f; }

	public Point getNextRow(Container container, int start)
	{
//		LOG("LineLayout.getNextRow << " + start);
		Insets insets = container.getInsets();
		int x = insets.left, r = container.getSize().width - insets.left - insets.right;
		int ht = 0;
		int count = container.getComponentCount();
		Point best = new Point(start, 0);
		for(int i = start, n = count; i < n; i++)
		{
			if(i > start)
				x += inner_gap;
			Component component = container.getComponent(i);
			Dimension size = component.getPreferredSize();
			x += size.width;
			ht = Math.max(ht, size.height);
			if(!nobreak)
			{
				if(x > r && best.x > start)
				{
//					LOG("LineLayout.getNextRow >> " + best);
					return best;
				}
				if(x <= r && component instanceof Strut)
				{
					best.x = i + 1;
					best.y = ht;
				}
			}
		}
		if(nobreak || x <= r || best.x <= start)
		{
			best.x = count;
			best.y = ht;
		}
//		LOG("/LineLayout.getNextRow >> " + best);
		return best;
	}

	public void layoutContainer(Container container)
	{
//		LOG("LineLayout.layoutContainer");
		Insets insets = container.getInsets();
		int x = insets.left, y = insets.top;
		int count = container.getComponentCount();
		int i = 0;
		while(i < count)
		{
			Point next = getNextRow(container, i);
			for(; i < next.x; i++)
			{
				Component component = container.getComponent(i);
				Dimension dim = new Dimension(component.getPreferredSize());
				int posy = y + ((next.y - dim.height) >> 1);
//				LOG("LineLayout[" + i + "] >> x = " + x + ", y = " + posy);
				component.setBounds(x, posy, dim.width, dim.height);
				x += dim.width + inner_gap;
			}
			y += next.y + inner_gap;
			x = insets.left;
		}
//		LOG("/LineLayout.layoutContainer");
	}

	public Dimension minimumLayoutSize(Container container)
	{
		return getLayoutSize(container); //, new SizeEvaluator()
		//{ public Dimension getSize(Component component) { return component.getMinimumSize(); } });
	}

	public Dimension preferredLayoutSize(Container container)
	{
		return getLayoutSize(container); //, new SizeEvaluator()
		//{ public Dimension getSize(Component component) { return component.getPreferredSize(); } });
	}

	public Dimension maximumLayoutSize(Container container)
	{
		return getLayoutSize(container); //, new SizeEvaluator()
		//{ public Dimension getSize(Component component) { return component.getMaximumSize(); } });
	}

	public Dimension getLayoutSize(Container container) //, SizeEvaluator sizer)
	{
//    	LOG("LineLayout.getLayoutSize");
		Insets insets = container.getInsets();
		int h = insets.top + insets.bottom;
		int count = container.getComponentCount();
		int i = 0;
		while(i < count)
		{
			if(i > 0)
				h += inner_gap;
			Point next = getNextRow(container, i);
			h += next.y;
			i = next.x;
		}
//    	LOG("/LineLayout.getLayoutSize >> height = " + h);
		return new Dimension(container.getSize().width, h);
	}

/*
	private static interface SizeEvaluator
	{
		public abstract Dimension getSize(Component component);
	};
*/
	private int inner_gap;
	private boolean nobreak;
}
