#include <utility/misc.jinc>

#define LNGMODULE Lang

package utility;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class ModalDialog extends Dialog
{
	public ModalDialog(Component owner, String title, boolean modal)
	{
		super(GUtil.getFrame(owner), title, modal);
		this.owner = owner;
		setLayout(null);
		addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent a)
			{
				endModalLoop(-1);
			}
		});
		font_size = GUtil.getFontSize();
		hotkey = new KeyAdapter()
		{
			public void keyPressed(KeyEvent e)
			{
				if(e.getKeyCode() == KeyEvent.VK_ENTER)
				{
					if(ModalDialog.this.accept())
						ModalDialog.this.endModalLoop(1);
				}
				if(e.getKeyCode() == KeyEvent.VK_ESCAPE)
					ModalDialog.this.endModalLoop(0);
			}
		};
	}

	public ModalDialog(Component owner, String title)
	{
		this(owner, title, true);
	}

	public ModalDialog(Component owner)
	{
		this(owner, "");
	}

	public ModalDialog focus(Component fo) { focus_owner = fo; return this; }

	public Insets getGap() { return gap; }

	public synchronized void setGap(Insets i)
	{
		gap = i;
		invalidate();
		validate();
//		doLayout();
	}

	public void setGap(int w, int h)  { setGap(new Insets(h, w, h, w)); }
	public void setGap(Dimension dim) { setGap(dim.width, dim.height); }
	public void setGap(int gap)       { setGap(gap, gap); }

	public void setDlgSize(int wd, int ht)
	{
		dlg_size = new Dimension(wd, ht);
	}

	public void setDlgSize(Dimension dim)
	{
		dlg_size = dim;
	}

	public Insets getClientInsets()
	{
		Insets insets = getInsets();
		return new Insets(insets.top + gap.top, insets.left + gap.left,
			insets.bottom + gap.bottom, insets.right + gap.right);
	}

	public Dimension getClientSize()
	{
		Insets insets = getClientInsets();
		Dimension dim = getSize();
		return new Dimension(dim.width - insets.left - insets.right,
			dim.height - insets.top - insets.bottom);
	}

	public void paint(Graphics g)
	{
		super.paint(g);
		Insets insets = getClientInsets();
//        LOG("insets = " + insets);
		g.translate(insets.left, insets.top);
	}

	public int fontToX(int x) { return x * font_size.width / 8; }
	public int fontToY(int y) { return y * font_size.height / 10; }

	public synchronized void add(Rectangle rc, Component component)
	{
		int ix = getComponentCount();
		super.add(component);
		locations.setSize(ix);
		locations.addElement(rc);
		max_size.width  = Math.max(max_size.width,  rc.x + rc.width);
		max_size.height = Math.max(max_size.height, rc.y + rc.height);
	}

	public void add(int x, int y, int w, int h, Component component)
	{
		add(new Rectangle(x, y, w, h), component);
	}

	public synchronized void fadd(Rectangle frc, Component component)
	{
		add(new Rectangle(fontToX(frc.x), fontToY(frc.y),
			fontToX(frc.width), fontToY(frc.height)), component);
	}

	public void fadd(int x, int y, int w, int h, Component component)
	{
		fadd(new Rectangle(x, y, w, h), component);
	}

	public void fadd(int x, int y, int w, int h, String text)
	{
		fadd(new Rectangle(x, y, w, h), new Label(text));
	}

	public ActionButton getOK()     { return new ActionButton(t_("OK"))     { public void doAction() { if(accept()) endModalLoop(1); } }; }
	public ActionButton getCancel() { return new ActionButton(t_("Cancel")) { public void doAction() { endModalLoop(0); } }; }

	public void okCancel()
	{
		int w = fontToX(80), h = fontToY(16), g = fontToX(10);
		int x = Math.max(max_size.width - 2 * w - g, 0), y = max_size.height + g;
		add(x,         y, w, h, getOK());
		add(x + w + g, y, w, h, getCancel());
	}

	public void setHotKey()
	{
		if(hotkey != null)
			GUtil.setKeyListenerDeep(this, hotkey);
	}

	public int run()
	{
		setHotKey();
		if(focus_owner == null && owner != null && owner instanceof Window)
			focus_owner = ((Window)owner).getFocusOwner();
		if(owner != null)
			owner.setEnabled(false);
		setVisible(true); // here starts the modal loop
		if(focus_owner != null)
			focus_owner.requestFocus();
		focus_owner = null;
		if(exit_code == 1)
			doOK();
		else if(exit_code <= 0)
			doCancel();
		return exit_code;
	}

	public boolean runOK() { return run() > 0; }

	public boolean accept() { return tryPump(true); }
	public void    pump(boolean write) throws Pump.PumpException {}
	public boolean tryPump(boolean write)
	{
		try
		{
			pump(write);
			return true;
		}
		catch(Pump.PumpException e)
		{
			e.show();
			return false;
		}
	}

	public void endModalLoop(int _exit_code)
	{
		exit_code = _exit_code;
		if(owner != null)
			owner.setEnabled(true);
		if(focus_owner != null)
			focus_owner.requestFocus();
		setVisible(false);
	}

	public void doOK() {}
	public void doCancel() {}

	public void doLayout()
	{
		Insets total = getClientInsets();
		int sx = dlg_size.width + total.left + total.right;
		int sy = dlg_size.height + total.top + total.bottom;
		for(int i = 0; i < getComponentCount(); i++)
		{
			Component co = getComponent(i);
			Rectangle rc = new Rectangle((Rectangle)locations.elementAt(i));
			if(rc.width == 0 || rc.height == 0)
			{
				Dimension dim = co.getPreferredSize();
				if(rc.width == 0) rc.width = dim.width;
				if(rc.height == 0) rc.height = dim.height;
			}
			rc.x += total.left;
			rc.y += total.top;
			co.setBounds(rc);
			sx = Math.max(sx, rc.x + rc.width + total.right);
			sy = Math.max(sy, rc.y + rc.height + total.bottom);
		}
		Dimension old_size = getSize();
		if(old_size.width != sx || old_size.height != sy)
		{
			Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
			setBounds((screen.width - sx) >> 1, (screen.height - sy) >> 1, sx, sy);
		}
	}

	protected Component owner;
	protected Component focus_owner;

	private Vector locations = new Vector();
	private Insets gap = new Insets(5, 5, 5, 5);
	private Frame frame;
	private int exit_code;
	private Dimension dlg_size = new Dimension(0, 0);
	private Dimension font_size;
	private Dimension max_size = new Dimension(0, 0);
	protected KeyListener hotkey;
}
