#include <utility/misc.jinc>

#define LLOG(x) // RLOG(x)

package utility;

import java.util.*;

public class QuitMap
{
	public static void add(Quittable quit)
	{
		synchronized(table)
		{
			for(int i = 0; i < table.size(); i++)
				if(table.elementAt(i) == quit)
					return;
			table.addElement(quit);
			LLOG("QuitMap.add " + quit + ", #items = " + table.size());
		}
	}

	public static void remove(Quittable quit)
	{
		synchronized(table)
		{
			for(int i = 0; i < table.size(); i++)
				if(table.elementAt(i) == quit)
				{
					table.removeElementAt(i);
					LLOG("QuitMap.remove " + quit + ", #items = " + table.size());
					return;
				}
		}
	}

	public static void quit()
	{
		synchronized(table)
		{
			LLOG("QuitMap.quit, #items = " + table.size());
			for(int i = 0; i < table.size(); i++)
			{
				Quittable item = (Quittable)table.elementAt(i);
				item.quit();
			}
			table.removeAllElements();
			LLOG("//QuitMap.quit");
		}
	}

	private static Vector table = new Vector();
}
