 ///////////////////////////////////////////////////////////////////
// ScrollBar: horizontal / vertical scrollbar.

#include <utility/misc.jinc>

#define LLOG(x) // RLOG(x)

package utility;

import java.awt.*;
import java.awt.event.*;

public class ScrollBar extends Panel
{
	///////////////////////////////////////////////////////////////////

	public ScrollBar(boolean horizontal)
	{
		slider = new Slider(horizontal);
		setLayout(null);
		less = new IconButton(map, 0, IconButton.HIGH | IconButton.PUSH | IconButton.REPEAT)
		{ protected void doAction() { slider.doPrevUnit(); } };
		more = new IconButton(map, 0, IconButton.HIGH | IconButton.PUSH | IconButton.REPEAT)
		{ protected void doAction() { slider.doNextUnit(); } };
		add(less);
		add(more);
		add(slider);
//		map = new MiscImageMap();
	}

	public void setBackground(Color c)
	{
		super.setBackground(c);
		slider.setBackground(c);
	}
	
	public void setForeground(Color c)
	{
		super.setForeground(c);
		slider.setForeground(c);
		less.setBackground(c);
		more.setBackground(c);
	}

	public boolean isHorizontal()               { return slider.isHorizontal(); }
	public void    setHorizontal(boolean horz)  { slider.setHorizontal(horz); }
	public int     getValue()                   { return slider.getValue(); }
	public void    setValue(int value)          { slider.setValue(value); }
	public int     getVisibleAmount()           { return slider.getVisibleAmount(); }
	public void    setVisibleAmount(int amount) { slider.setVisibleAmount(amount); }
	public int     getMinimum()                 { return slider.getMinimum(); }
	public void    setMinimum(int min)          { slider.setMinimum(min); }
	public int     getMaximum()                 { return slider.getMaximum(); }
	public void    setMaximum(int max)          { slider.setMaximum(max); }

	public void    doBegin()                    { slider.doBegin(); }
	public void    doPrevBlock()                { slider.doPrevBlock(); }
	public void    doPrevUnit()                 { slider.doPrevUnit(); }
	public void    doNextUnit()                 { slider.doNextUnit(); }
	public void    doNextBlock()                { slider.doNextBlock(); }
	public void    doEnd()                      { slider.doEnd(); }
	public void    doKey(KeyEvent e)            { slider.doKey(e); }
	public void    doKey(KeyEvent e, boolean twin_keys) { slider.doKey(e, twin_keys); }

	public void    addScrollListener(ScrollAdapter a)     { slider.addScrollListener(a); }
	public void    removeScrollListener(ScrollAdapter a)  { slider.removeScrollListener(a); }

	///////////////////////////////////////////////////////////////////

	public int     getOrientation()             { return slider.getOrientation(); }
	public int     getUnitIncrement()           { return slider.getUnitIncrement(); }
	public void    setUnitIncrement(int _shift) { slider.setUnitIncrement(_shift); }

	public int     getBlockIncrement()          { return slider.getBlockIncrement(); }
	public void    setBlockIncrement(int _shift) { slider.setBlockIncrement(_shift); }

	///////////////////////////////////////////////////////////////////

	public Dimension getPreferredSize()
	{
		Dimension sps = new Dimension(slider.getPreferredSize());
		if(isHorizontal())
			sps.width += 2 * STDBUTT;
		else
			sps.height += 2 * STDBUTT;
		return sps;
	}

	//////////////////////////////////////////////////////////////////////

	public synchronized void repaint_layout()
	{
		dirty_layout = true;
		LLOG("Splitter.repaint_layout -> dirty_layout = " + dirty_layout + ", this = " + this);
		repaint();
	}

	//////////////////////////////////////////////////////////////////////

	public synchronized void paint(Graphics g)
	{
		if(dirty_layout)
		{
			LLOG("ScrollBar.paint -> layout");
			dirty_layout = false;
			invalidate();
			validate();
//			doLayout();
			LLOG("//ScrollBar.paint -> layout");
		}
		super.paint(g);
	}

	///////////////////////////////////////////////////////////////////

	public void doLayout()
	{
		super.doLayout();
		synchronized(this)
		{
			if(laying)
				return;
			laying = true;
		}
		Dimension dim = getSize();
		Insets ins = getInsets();
		Dimension vport = new Dimension(dim.width - ins.left - ins.right, dim.height - ins.top - ins.bottom);

		if(slider.isHorizontal())
		{ // lay out horizontal bar
			less.setIconIndex(MiscImageMap.LEFT);
			more.setIconIndex(MiscImageMap.RIGHT);
			int butt = Math.min(vport.width >> 2, STDBUTT);
			less.setBounds(ins.left, ins.top, butt, vport.height);
			more.setBounds(dim.width - ins.right - butt, ins.top, butt, vport.height);
			slider.setBounds(ins.left + butt, ins.top, vport.width - 2 * butt, vport.height);
		}
		else
		{
			less.setIconIndex(MiscImageMap.UP);
			more.setIconIndex(MiscImageMap.DOWN);
			int butt = Math.min(vport.height >> 2, STDBUTT);
			less.setBounds(ins.left, ins.top, vport.width, butt);
			more.setBounds(ins.left, dim.height - ins.bottom - butt, vport.width, butt);
			slider.setBounds(ins.left, ins.top + butt, vport.width, vport.height - 2 * butt);
		}
//		slider.doLayout();
		laying = false;
	}

	///////////////////////////////////////////////////////////////////

	private final int STDBUTT = 16;
	private boolean laying = false;
	private IconButton less, more;
	private static MiscImageMap map = new MiscImageMap();
	private Slider slider;
	private boolean dirty_layout = true;
}
