package utility.formatting;

import java.awt.*;
import java.awt.image.*;
import utility.*;

public class ImageDisplayItem implements DisplayItem
{
	public ImageDisplayItem(Image image, ImageObserver observer)
	{
		this.image = image;
		this.observer = observer;
	}

	public ImageDisplayItem(String url, ImageObserver observer)
	{
		this(GUtil.getImage(url), observer);
	}

	public final int  getAscent()  { return image.getHeight(observer); }
	public final int  getDescent() { return 0; }
	public final int  getLeading() { return 0; }
	public final int  getWidth()   { return image.getWidth(observer); }

	public final void paint(Graphics g, int left, int baseline)
	{
		g.drawImage(image, left, baseline - image.getHeight(observer), observer);
	}

	private Image image;
	private ImageObserver observer;
}
