package utility.formatting;

import java.awt.*;
import java.awt.image.*;
import utility.*;

public class StyleDisplayItem implements DisplayItem
{
	public StyleDisplayItem(Color color)
	{
		this.color = color;
		this.font = new Font("SansSerif", Font.BOLD, 12);
	}

	public final int  getAscent()  { return 17; }
	public final int  getDescent() { return 4; }
	public final int  getLeading() { return 0; }
	public final int  getWidth()   { return 17; }

	public final void paint(Graphics g, int left, int baseline)
	{
		Color c = g.getColor();
		int a = getAscent(), w = getWidth();
		GUtil.drawRect(g, left, baseline - a, w, a, 1, Color.black);
		GUtil.fillRect(g, left + 1, baseline - a + 1, w - 2, a - 2, color);
		g.setColor(c);
		Font f = g.getFont();
		g.setFont(f);
		FontMetrics fi = g.getFontMetrics();
		int wd = fi.charWidth('U');
		g.drawString("U", left + (w - wd + 2) >> 1, baseline - 4);
	}

	private Color color;
	private Font font;
}
