#include "IdisTDoc.h"

#define  IMAGEFILE  <IdisTDoc/IdisTDoc.iml>
#define  IMAGECLASS TDocImg
#include <Draw/iml.h>

void DataFieldCtrl::Paint(Draw& w)
{
	Size sz = GetSize();
	if(text.IsEmpty())
		w.DrawRect(sz, White);
	else
		w.DrawRect(sz, Blend(LtGreen, White));
	w.DrawText(2, (sz.cy - Draw::GetStdFontCy()) / 2, text, StdFont().Bold(), SBlack);
}

void DataFieldCtrl::LeftDouble(Point, dword)
{
	DblClick();
}

FileSel& PDFs()
{
	static FileSel fs;
	static bool init;
	if(!init) {
		init = true;
		fs.Type("PDF soubor", "*.pdf");
		fs.AllFilesType();
		fs.DefaultExt("pdf");
	}
	return fs;
}

void TDoc::Pdf()
{
//	FileSel& fs = PDFs();
//	if(!fs.ExecuteSaveAs("PDF Vstup"))
//		return;
	Size page = Size(3968, 6047);
	PdfDraw pdf;
	::Print(pdf, editor.Get(), page);
	String pdff = GetExeDirFile("pdf");
	DirectoryCreate(pdff);
	pdff = AppendFileName(pdff, "dokument.pdf");
	SaveFile(pdff, pdf.Finish());
	LaunchWebBrowser(pdff);
//	PromptOK("PDF uloeno do&[* \1" + pdff);
//	SaveFile(~fs, pdf.Finish());
}

void TDoc::AddBar(Bar& bar) {}

void TDoc::DoPrint(bool preview)
{
	WhenNotes();
	const RichText& text = editor.Get();
	DocPrint p;
	int q = data.Find("WATERMARK");
	if(q >= 0)
		p.watermark_qtf = data[q].text;
	p.footer = footer;
	q = data.Find("FOOTER");
	if(q >= 0)
		p.footer = data[q].text;
	p.header = header;
	if(preview)
		p.Preview(text, editor.GetPage());
	else
		p.Print(text, editor.GetPage(), 0);
}

void TDoc::VarField()
{
	RichText::FormatInfo fi = editor.GetFormatInfo();
	fi.link = IsNull(fi.link) ? "1" : "";
	fi.charvalid = RichText::LINK;
	fi.paravalid = 0;
	editor.ApplyFormatInfo(fi);
}

void TDoc::Regen()
{
	if(PromptYesNo("Obnovit datov pole?"))
		editor.Pick(Expand(GetPurifiedText(), data));
}

struct RepairingIterator : RichText::UpdateIterator {
	VectorMap<String, Index<String> > *repair_base[2];

	WString Phase2(const WString& text) {
		WString part;
		WString w;
		const wchar *s = text;
		for(;;) {
			if(*s == ' ' || *s == 160 || *s == '-' || *s == 0) {
				int q = repair_base[1]->Find(FromUnicode(w));
				if(q >= 0) {
					const Index<String>& x = (*repair_base[1])[q];
					part.Cat(ToUnicode(x[0], CHARSET_DEFAULT));
				}
				else
					part.Cat(w);
				w.Clear();
				if(*s == 0) break;
				part.Cat(*s++);
			}
			else
				w.Cat(*s++);
		}
		return part;
	}

	virtual int operator()(int pos, RichPara& para) {
		for(int i = 0; i < para.GetCount(); i++) {
			RichPara::Part& part = para[i];
			if(part.IsText()) {
				WString text = part.text;
				part.text.Clear();
				WString w;
				const wchar *s = text;
				for(;;) {
					if((byte)*s < 128 && !IsAlpha(*s) && *s != ' ' || *s == 0) {
						DUMP(w);
						if(w[0] == ' ') {
							DUMP(FromUnicode(w.Mid(1)));
							DUMP(repair_base[0]->Find(FromUnicode(w.Mid(1))));
						}
						WString spc, rspc;
						while(w[0] == ' ') {
							w = w.Mid(1);
							spc.Cat(' ');
						}
						while(w.GetLength() && *w.Last() == ' ') {
							w.Trim(w.GetLength() - 1);
							rspc.Cat(' ');
						}
						int q = repair_base[0]->Find(FromUnicode(w));
						if(q >= 0) {
							const Index<String>& x = (*repair_base[0])[q];
							part.text.Cat(spc + ToUnicode(x[0], CHARSET_DEFAULT) + rspc);
						}
						else
							part.text.Cat(spc + Phase2(w) + rspc);
						w.Clear();
						if(*s == 0) break;
						part.text.Cat(*s++);
					}
					else
						w.Cat(*s++);
				}
			}
		}
		return RichText::UpdateIterator::UPDATE;
	}
};

void TDoc::Repair()
{
	RichText txt = ParseQTF(editor.GetQTF());
	RepairingIterator it;
	it.repair_base[0] = repair_base[0];
	it.repair_base[1] = repair_base[1];
	txt.Iterate(it);
	editor.Pick(txt);
}

void TDoc::ToolBar(Bar& bar)
{
	editor.SpellCheckTool(bar);
	bar.Separator();
	editor.EditTools(bar);
	bar.Separator();
	editor.TableTools(bar);
	bar.Separator();
	editor.StyleTool(bar);
	bar.Gap();
	editor.ParaTools(bar);
	bar.Break();
	editor.FontTools(bar);
	editor.InkTool(bar);
	editor.PaperTool(bar);
	bar.Gap();
	editor.LanguageTool(bar);
	bar.Separator();
	RichText::FormatInfo fi = editor.GetFormatInfo();
	bar.Add("Vloit datov pole", TDocImg::InsertDataField(), THISBACK(InsertDataField))
	   .Key(K_CTRL_INSERT);
	bar.Add(dfc, 120);
	bar.Add("Promnn pole", TDocImg::VarField(), THISBACK(VarField))
	   .Check(fi.link.GetCount() && (fi.charvalid & RichText::LINK))
	   .Key(K_CTRL_M);
	bar.Add("Pejt na dal promnn pole", TDocImg::Asterisk(), THISBACK(NextField))
	   .Key(K_CTRL_TAB);
	bar.Separator();
	bar.Add("Obnovit datov pole", TDocImg::Regen(), THISBACK(Regen));
//	if(WhenSaveTDoc) {
//		bar.Separator();
//		bar.Add("Uloit jako ablonu", TDocImg::SaveTDoc, Proxy(WhenSaveTDoc));
//	}
	bar.Separator();
	bar.Add("Vytisknout", CtrlImg::print(), THISBACK1(DoPrint, false))
	   .Key(K_CTRL_P);
	bar.Add("Nhled", TDocImg::Preview(), THISBACK1(DoPrint, true))
	   .Key(K_CTRL_P);
	bar.Add("PDF vstup", TDocImg::PDF(), THISBACK(Pdf));
	if(repair_base[0]) {
		bar.Add("Oprava", CtrlImg::Toggle(), THISBACK(Repair));
	}
	if(WhenOsoba)
		bar.Add("Osoba..", TDocImg::Osoba(), THISBACK(InsertOsoba));
	AddBar(bar);
}

struct DataDlg : WithDataLayout<TopWindow> {
	const VectorMap<String, NamedText>& data;

	void EnterField();

	typedef DataDlg CLASSNAME;

	DataDlg(const VectorMap<String, NamedText>& data);
};

void DataDlg::EnterField()
{
	text.Clear();
	if(field.IsCursor()) {
		int q = data.Find(field.GetKey());
		if(q >= 0) {
			Value d = data[q].text;
			if(IsString(d))
				text <<= d;
		}
	}
}

DataDlg::DataDlg(const VectorMap<String, NamedText>& data)
:	data(data)
{
	CtrlLayoutOKCancel(*this, "Vloit datov pole");
	field.AddKey();
	field.AddColumn();
	field.NoHeader().NoGrid();
	field.WhenEnterRow = THISBACK(EnterField);
	field.WhenLeftDouble = Breaker(IDOK);
	for(int i = 0; i < data.GetCount(); i++)
		if(data.GetKey(i) != "FOOTER" && data.GetKey(i) != "WATERMARK")
			field.Add(data.GetKey(i), data[i].name);
	field.GoBegin();
}

void TDoc::InsertDataField()
{
	DataDlg dlg(data);
	if(dlg.Execute() != IDOK || !dlg.field.IsCursor())
		return;
	int i = data.Find(dlg.field.GetKey());
	if(i < 0)
		return;
	String d = data[i].text;
	RichText txt = ParseQTF(String().Cat() << "[I" << data.GetKey(i) << "; " << d << "]");
	txt.Normalize();
	editor.PasteText(txt);
	RemoveDataFieldStyle();
}

void TDoc::SetToolBar() {
	dfc.Set(data.Get(editor.GetFormatInfo().indexentry.ToString(), NamedText()).name);
	toolbar.Set(THISBACK(ToolBar));
}

void TDoc::InsertOsoba()
{
	String s;
	WhenOsoba(s);
	editor.PasteText(AsRichText(s.ToWString(), editor.GetFormatInfo()));
}

bool TDoc::Execute()
{
	TopWindow win;
	win.Add(SizePos());
	win.Sizeable().Zoomable();
	win.Maximize();
	win.ActiveFocus(*this);
	LoadDocSettings(win, editor);
	for(;;) {
		win.Run();
		SaveDocSettings(win, editor);
		switch(PromptYesNoCancel("Uloit proveden zmny?")) {
		case 0:
			return false;
		case 1:
			return true;
		}
	}
}

struct NextFieldIterator : public RichText::Iterator {
	int l;
	int ln;
	virtual bool operator()(int pos, const RichPara& para) {
		for(int i = 0; i < para.GetCount(); i++) {
			const RichPara::Part& p = para[i];
			if(pos + p.GetLength() > l) {
				if(!IsNull(p.format.link) && pos + p.GetLength() > l) {
					l = pos;
					ln = p.GetLength();
					i++;
					while(i < para.GetCount()) {
						const RichPara::Part& p1 = para[i];
						if(IsNull(p1.format.link))
							return true;
						ln += p1.GetLength();
						i++;
					}
					return true;
				}
				if(p.IsText())
					for(int q = 0; q < p.text.GetLength(); q++)
						if(q + pos >= l && p.text[q] == '*' && p.text[q + 1] == '*' &&
						   p.text[q + 2] == '*' && p.text[q + 3] == '*') {
							l = pos + q;
							ln = 4;
							return true;
						}
			}
			pos += p.GetLength();
		}
		return false;
	}
};

void TDoc::NextField()
{
	NextFieldIterator ni;
	ni.l = editor.GetCursor() + 1;
	if(editor.Get().Iterate(ni)) {
		editor.Select(ni.l, ni.ln);
		return;
	}
	ni.l = 0;
	if(editor.Get().Iterate(ni))
		editor.Select(ni.l, ni.ln);
}

void TDoc::RemoveDataFieldStyle()
{
	RichText::FormatInfo fi;
	fi.charvalid = RichText::INDEXENTRY;
	fi.paravalid = 0;
	editor.ApplyFormatInfo(fi);
}

String TDoc::GetText() const
{
	return AsQTF(editor.Get(), CHARSET_WIN1250, QTF_BODY|QTF_NOSTYLES|QTF_CRLF);
}

String TDoc::GetPurifiedText() const
{
	return AsQTF(Purify(editor.Get()), CHARSET_WIN1250, QTF_BODY|QTF_NOSTYLES|QTF_CRLF);
}

TDoc::TDoc()
{
	Add(editor.SizePos());
	editor.InsertFrame(0, toolbar);
	editor.InsertFrame(0, TopSeparatorFrame());
	editor.WhenRefreshBar = THISBACK(SetToolBar);
	editor.PrintNoLinks();
	SetToolBar();
	dfc.DblClick = THISBACK(RemoveDataFieldStyle);
	notes = false;
	repair_base[0] = repair_base[1] = NULL;
}
