#ifndef _IdisTDoc_IdisTDoc_h
#define _IdisTDoc_IdisTDoc_h

#include <IdisMisc/IdisMisc.h>
#include <RichEdit/RichEdit.h>
#include <PdfDraw/PdfDraw.h>

#define  LAYOUTFILE <IdisTDoc/IdisTDoc.lay>
#include <CtrlCore/lay.h>

VectorMap<String, Value> QtfText(const VectorMap<String, Value>& var);

struct NamedText : Moveable<NamedText> {
	String name;
	String text;
};

RichText Expand(const char *qtf, const VectorMap<String, NamedText>& map);
RichText Purify(const RichText& text);

String MacroExpand(const char *term, const VectorMap<String, String>& macro);
String ExpandText(const String& text, const VectorMap<String, Value>& var, const VectorMap<String, String>& macro);
VectorMap<String, NamedText> MakeTData(const VectorMap<String, Value>& data,
                                       const VectorMap<String, String>& macro,
                                       const Vector<String>& name);

struct DataFieldCtrl : public Ctrl {
	virtual void Paint(Draw& w);
	virtual void LeftDouble(Point, dword);
	virtual Size GetMinSize() const         { int q = EditField::GetStdHeight(); return Size(q, q); }

	String text;

	Callback DblClick;

	void   Set(const String& t)             { text = t; Refresh(); }

	DataFieldCtrl()                         { SetFrame(InsetFrame()); }
};

struct SablonaName : WithSablonaNameLayout<TopWindow> {
	EditString edit;
	SablonaName(const char *name = "Jmno ablony");
};

struct DocPrint {
	String watermark_qtf;
	String footer;
	String header;

	void Print(Draw& w, const RichText& text, const Rect& page, int firstpage, int lastpage, int copies, bool collate, bool report = false);
	void Print(HDC hdc, const RichText& text, const Rect& page, int firstpage, int lastpage, int copies, bool collate, const char *name);
	bool Print(const RichText& text, const Rect& page, int currentpage);
	void Preview(const RichText& text, const Rect& page);
};

class TDoc : public Ctrl {
public:
	virtual void GotFocus()              { editor.SetFocus(); }

private:
	ToolBar                      toolbar;
	DataFieldCtrl                dfc;

	void ToolBar(Bar& bar);
	void InsertOsoba();
	void SetToolBar();
	void NextField();
	void InsertDataField();
	void RemoveDataFieldStyle();
	void VarField();
	void Regen();
	void Repair();

	void Print(Draw& w, const RichText& text, const Rect& page, int firstpage, int lastpage,
	           int copies, bool collate);
	void Print(HDC hdc, const RichText& text, const Rect& page, int firstpage, int lastpage,
	           int copies, bool collate, const char *name);
	bool Print(const RichText& text, const Rect& page, int currentpage);

public:
	virtual void AddBar(Bar& bar);

	RichEdit                     editor;
	VectorMap<String, NamedText> data;
	VectorMap<String, Index<String> > *repair_base[2];

	String notes_odbor;
	String notes_cj;
	String notes_rok;

	String notes_vec;
	String notes_adresat;
	String notes_ulice;
	String notes_mesto;
	String notes_zeme;
	String notes_psc;

	String notes_ccj;

	String header;
	String footer;

	bool   notes;


	void   SetText(const char *qtf)      { editor.SetQTF(qtf); }

	String GetText() const;
	String GetPurifiedText() const;

	bool   Execute();

	void   Pdf();
	void   DoPrint(bool preview = false);

	Callback WhenNotes;
	Callback WhenSaveTDoc;
	Callback1<String &> WhenOsoba;

	typedef TDoc CLASSNAME;

	TDoc();
};

void   SablonyEdit(const VectorMap<String, Value>& vars);

//String CreateTDoc(const VectorMap<String, Value>& vars);

struct TDocS {
	SqlId SABLONA, SABLONA_SEQ, NAZEV, TEXT, SKUPINA, SKUPINA_SEQ, SNAZEV;
	SqlId MACRO, MACRO_SEQ, ID, MNAZEV, LTEXT;
	SqlSequence *Seq;
	SqlId TYP, PRISTUP;
	WithDeepCopy< VectorMap<Value, String> > typlist;
};

void EditMacros(const TDocS& ids, const VectorMap<String, Value>& data);

void LoadMacros(TDocS& ts, VectorMap<String, String>& macro, Vector<String>& name);

void EditSablony(const TDocS& ids, const VectorMap<String, NamedText>& data);
void SaveSablona(const String& text, const TDocS& ids,
                 const VectorMap<String, NamedText>& data, Value typ = Null);

void ExportDocs(const TDocS& ids);
void ImportDocs(const TDocS& ids);

extern int tdoc_skupina_seq;

struct TDocDlg {
	TDocS         ts;
	TimeCallback  tm;
	ArrayCtrl     skupina, sablona;
	RichTextView  view;

	virtual void SablonaChanged() {}
	virtual VectorMap<String, Value> MakeVars() = 0;

	void Skupina();
	void SablonaCursor();

	void CreateMode(Ctrl& p);
	void SablonaRefresh();
	void EndCreateMode();

	Callback DataCall() {
		return callback2(&tm, &TimeCallback::KillSet, 300, THISBACK(SablonaRefresh));
	}

	typedef TDocDlg CLASSNAME;

	TDocDlg(TDocS ts);
};

extern String DocSettings;
void LoadDocSettings(TopWindow& win, RichEdit& e);
void SaveDocSettings(TopWindow& win, RichEdit& e);

#endif
